/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server.handler.core.message;

import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.data.message.JobParametersMessage;
import net.scattersphere.job.stream.StreamRegistry;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.handler.core.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

public class StreamMessageHandler
implements MessageHandler {
    private static final String MESSAGE = "STREAM";
    private final Logger LOG = LoggerFactory.getLogger(StreamMessageHandler.class);

    @Override
    public void handle(JobMessage message, ClientConnection client) {
        JobParametersMessage parameters = JobParametersMessage.fromByteArray(message.getPayload());
        String streamId = parameters.getJobName();
        String streamCommand = parameters.getJobMessage();
        this.LOG.info("Stream: ID={} Command={}", (Object)streamId, (Object)streamCommand);
        String responseString = null;
        switch (streamCommand.toLowerCase()) {
            case "status": {
                responseString = StreamRegistry.instance().getStatus(streamId);
                break;
            }
            case "size": {
                responseString = "" + StreamRegistry.instance().getSize(streamId);
                break;
            }
            default: {
                this.LOG.info("Unsupported stream command sent: {}", (Object)streamCommand);
            }
        }
        if (responseString != null) {
            JobMessage response = new JobMessage(MESSAGE, DataSerializer.serialize(responseString));
            Buffer buffer = new Buffer(DataSerializer.packetize(response.toByteArray()));
            client.getEndpoint().write(buffer);
        }
    }

    @Override
    public boolean canHandle(JobMessage message) {
        return message != null && message.getMessage().equals(MESSAGE);
    }
}

