/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server.handler.core.message;

import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.data.message.JobParametersMessage;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.handler.core.MessageHandler;
import net.scattersphere.util.thread.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

public class StopMessageHandler
implements MessageHandler {
    private static final String MESSAGE = "STOP";
    private final Logger LOG = LoggerFactory.getLogger(StopMessageHandler.class);

    @Override
    public void handle(JobMessage message, ClientConnection client) {
        JobParametersMessage parameters = JobParametersMessage.fromByteArray(message.getPayload());
        String jobId = parameters.getJobName();
        String jobStopMessage = parameters.getJobMessage();
        boolean stoppedJob = JobManager.instance().stop(jobId, jobStopMessage);
        this.LOG.info("Stop: ID={} reason={} result={}", jobId, jobStopMessage, stoppedJob);
        JobMessage response = new JobMessage(MESSAGE, DataSerializer.serialize(stoppedJob));
        Buffer buffer = new Buffer(DataSerializer.packetize(response.toByteArray()));
        client.getEndpoint().write(buffer);
    }

    @Override
    public boolean canHandle(JobMessage message) {
        return message != null && message.getMessage().equals(MESSAGE);
    }
}

