/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server.handler.core.message;

import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.handler.core.MessageHandler;
import net.scattersphere.util.thread.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

public class StatusMessageHandler
implements MessageHandler {
    private static final String MESSAGE = "STATUS";
    private final Logger LOG = LoggerFactory.getLogger(StatusMessageHandler.class);

    @Override
    public void handle(JobMessage message, ClientConnection client) {
        String jobId = message.getAction();
        String jobStatus = JobManager.instance().status(jobId);
        this.LOG.info("Status: ID={} result={}", (Object)jobId, (Object)jobStatus);
        JobMessage response = new JobMessage(MESSAGE, DataSerializer.serialize(jobStatus));
        Buffer buffer = new Buffer(DataSerializer.packetize(response.toByteArray()));
        client.getEndpoint().write(buffer);
    }

    @Override
    public boolean canHandle(JobMessage message) {
        return message != null && message.getMessage().equals(MESSAGE);
    }
}

