/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server.handler.core.message;

import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.data.message.JobParametersMessage;
import net.scattersphere.job.Job;
import net.scattersphere.job.registry.JobRegistry;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.handler.core.MessageHandler;
import net.scattersphere.util.thread.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

public class StartMessageHandler
implements MessageHandler {
    private static final String MESSAGE = "START";
    private final Logger LOG = LoggerFactory.getLogger(StartMessageHandler.class);

    @Override
    public void handle(JobMessage message, ClientConnection client) {
        JobParametersMessage parameters = JobParametersMessage.fromByteArray(message.getPayload());
        String jobName = parameters.getJobName();
        String[] jobParameters = parameters.getJobParameters();
        Job job = JobRegistry.instance().get(jobName);
        String jobId = JobManager.instance().queue(job, jobName, jobParameters);
        this.LOG.info("Start: job={} parameterCount={} jobId={}", jobName, jobParameters == null ? "0" : Integer.valueOf(jobParameters.length), jobId);
        JobMessage response = new JobMessage(MESSAGE, DataSerializer.serialize(jobId));
        Buffer buffer = new Buffer(DataSerializer.packetize(response.toByteArray()));
        client.getEndpoint().write(buffer);
    }

    @Override
    public boolean canHandle(JobMessage message) {
        return message != null && message.getMessage().equals(MESSAGE);
    }
}

