/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server.handler.core.message;

import java.util.ArrayList;
import java.util.Map;
import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.data.message.JobParametersMessage;
import net.scattersphere.data.message.JobResponseMessage;
import net.scattersphere.job.Job;
import net.scattersphere.job.registry.JobRegistry;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.handler.core.MessageHandler;
import net.scattersphere.util.thread.JobExecutionResult;
import net.scattersphere.util.thread.JobManager;
import net.scattersphere.util.thread.JobManagerCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

public class ListMessageHandler
implements MessageHandler {
    private static final String MESSAGE = "LIST";
    private final Logger LOG = LoggerFactory.getLogger(ListMessageHandler.class);

    @Override
    public void handle(JobMessage message, ClientConnection client) {
        if (message.getPayload() != null) {
            JobParametersMessage parameters = JobParametersMessage.fromByteArray(message.getPayload());
            ArrayList<JobResponseMessage> returnList = new ArrayList<JobResponseMessage>();
            JobMessage response = null;
            Buffer buffer = null;
            switch (parameters.getJobName().toLowerCase()) {
                case "queued": {
                    JobManager.instance().getQueuedJobs().stream().forEach(x -> returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.QUEUED.toString())));
                    break;
                }
                case "running": {
                    JobManagerCache.instance().getRunningJobs().stream().forEach(x -> returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.RUNNING.toString())));
                    break;
                }
                case "completed": {
                    JobManagerCache.instance().getCompletedJobs().stream().forEach(x -> returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.COMPLETED.toString())));
                    break;
                }
                case "stopped": {
                    JobManagerCache.instance().getFailedJobs().stream().forEach(x -> {
                        if (x.getJobContext().getJobResult() == JobExecutionResult.STOPPED) {
                            returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.STOPPED.toString(), x.getJobContext().getJobStopReason(), null));
                        }
                    });
                    break;
                }
                case "failed": {
                    JobManagerCache.instance().getFailedJobs().stream().forEach(x -> {
                        if (x.getJobContext().getJobResult() == JobExecutionResult.FAILED) {
                            returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.FAILED.toString(), x.getJobContext().getJobStopReason(), x.getJobContext().getJobException()));
                        }
                    });
                    break;
                }
                case "all": {
                    JobManagerCache.instance().getRunningJobs().stream().forEach(x -> returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.RUNNING.toString())));
                    JobManager.instance().getQueuedJobs().stream().forEach(x -> returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.QUEUED.toString())));
                    JobManagerCache.instance().getCompletedJobs().stream().forEach(x -> returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.COMPLETED.toString())));
                    JobManagerCache.instance().getFailedJobs().stream().forEach(x -> {
                        if (x.getJobContext().getJobResult() == JobExecutionResult.STOPPED) {
                            returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.STOPPED.toString(), x.getJobContext().getJobStopReason(), null));
                        }
                    });
                    JobManagerCache.instance().getFailedJobs().stream().forEach(x -> {
                        if (x.getJobContext().getJobResult() == JobExecutionResult.FAILED) {
                            returnList.add(new JobResponseMessage(x.getJobContext().getJobId(), JobExecutionResult.FAILED.toString(), x.getJobContext().getJobStopReason(), x.getJobContext().getJobException()));
                        }
                    });
                    break;
                }
                default: {
                    Map<String, Class<? extends Job>> jobsList = JobRegistry.instance().getJobs();
                    for (String key : jobsList.keySet()) {
                        Class<? extends Job> jobClass = jobsList.get(key);
                        Job jobObject = null;
                        try {
                            jobObject = jobClass.newInstance();
                        }
                        catch (Exception ex) {
                            this.LOG.warn("Unable to create new instance of job: {}", (Object)jobClass, (Object)ex);
                            continue;
                        }
                        returnList.add(new JobResponseMessage(key, JobExecutionResult.AVAILABLE.toString(), jobObject.getDescription()));
                    }
                }
            }
            response = new JobMessage(MESSAGE, DataSerializer.serialize(returnList));
            buffer = new Buffer(DataSerializer.packetize(response.toByteArray()));
            client.getEndpoint().write(buffer);
        } else {
            ArrayList<JobResponseMessage> jobs = new ArrayList<JobResponseMessage>();
            Map<String, Class<? extends Job>> jobsList = JobRegistry.instance().getJobs();
            for (String key : jobsList.keySet()) {
                Class<? extends Job> jobClass = jobsList.get(key);
                Job jobObject = null;
                try {
                    jobObject = jobClass.newInstance();
                }
                catch (Exception ex) {
                    this.LOG.warn("Unable to create new instance of job: {}", (Object)jobClass, (Object)ex);
                    continue;
                }
                jobs.add(new JobResponseMessage(key, JobExecutionResult.AVAILABLE.toString(), jobObject.getDescription()));
            }
            JobMessage response = new JobMessage(MESSAGE, DataSerializer.serialize(jobs));
            Buffer buffer = new Buffer(DataSerializer.packetize(response.toByteArray()));
            client.getEndpoint().write(buffer);
        }
    }

    @Override
    public boolean canHandle(JobMessage message) {
        return message != null && message.getMessage().equals(MESSAGE);
    }
}

