/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server.handler.core;

import java.util.ArrayList;
import java.util.List;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.handler.core.MessageHandler;
import net.scattersphere.server.handler.core.message.ListMessageHandler;
import net.scattersphere.server.handler.core.message.StartMessageHandler;
import net.scattersphere.server.handler.core.message.StatusMessageHandler;
import net.scattersphere.server.handler.core.message.StopMessageHandler;
import net.scattersphere.server.handler.core.message.StreamMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class ConnectionReadHandler
implements Handler<Buffer> {
    private final ClientConnection client;
    private Buffer currentBuffer;
    private final List<MessageHandler> messageHandlers;
    private final Logger LOG = LoggerFactory.getLogger(ConnectionReadHandler.class);

    public ConnectionReadHandler(ClientConnection client) {
        this.client = client;
        this.currentBuffer = new Buffer();
        this.messageHandlers = new ArrayList<MessageHandler>();
        this.messageHandlers.add(new ListMessageHandler());
        this.messageHandlers.add(new StartMessageHandler());
        this.messageHandlers.add(new StopMessageHandler());
        this.messageHandlers.add(new StatusMessageHandler());
        this.messageHandlers.add(new StreamMessageHandler());
    }

    private void handleMessage(JobMessage message) {
        for (MessageHandler handler : this.messageHandlers) {
            if (!handler.canHandle(message)) continue;
            handler.handle(message, this.client);
            return;
        }
        this.LOG.warn("Unknown command received from client at {}: {}", (Object)this.client.getEndpoint().remoteAddress(), (Object)message.getMessage());
    }

    @Override
    public void handle(Buffer buffer) {
        byte[] data = null;
        if (this.client.getExpectedPayloadSize() == 0L) {
            int payloadSize = 0;
            if (buffer.length() > 4) {
                data = buffer.getBytes();
                payloadSize = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            }
            if ((long)payloadSize > 16384L) {
                this.LOG.debug("READ: unexpected payload size: sent={} max={}", (Object)payloadSize, (Object)16384L);
                this.client.getEndpoint().close();
                return;
            }
            this.LOG.debug("READ: payloadSize={} appendedBufferSize={}", (Object)payloadSize, (Object)buffer.length());
            byte[] newData = new byte[data.length - 4];
            System.arraycopy(data, 4, newData, 0, data.length - 4);
            this.client.setExpectedPayloadSize(payloadSize);
            this.client.getReadBuffer().setBytes(0, newData);
        } else {
            this.client.getReadBuffer().appendBuffer(buffer);
        }
        data = this.client.getReadBuffer().getBytes();
        if ((long)data.length >= this.client.getExpectedPayloadSize()) {
            int newBufferLength = (int)((long)data.length - this.client.getExpectedPayloadSize());
            byte[] newBuffer = null;
            this.client.clearReadBuffer();
            if (newBufferLength > 0) {
                newBuffer = new byte[newBufferLength];
                System.arraycopy(data, (int)this.client.getExpectedPayloadSize(), newBuffer, 0, newBufferLength);
                this.client.getReadBuffer().setBytes(0, newBuffer);
                this.LOG.debug("READ: appended read-ahead buffer: length={}", (Object)this.currentBuffer.length());
            }
            this.LOG.debug("READ: full packet received: length={}", (Object)this.client.getExpectedPayloadSize());
            JobMessage jMessage = JobMessage.fromByteArray(data);
            this.LOG.debug("READ: message requested: {}", (Object)jMessage);
            this.handleMessage(jMessage);
        }
    }
}

