/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server;

import java.util.Properties;
import net.scattersphere.job.stream.StreamRegistry;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.Main;
import net.scattersphere.server.handler.core.ConnectionCloseHandler;
import net.scattersphere.server.handler.stream.ConnectionReadHandler;
import net.scattersphere.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.NetSocket;

public class StreamServer {
    private final NetServer controllerServer;
    private final Properties properties = new Properties();
    private final Logger LOG = LoggerFactory.getLogger(StreamServer.class);

    public StreamServer(String[] args) {
        if (args.length > 0) {
            this.parseArguments(args);
        }
        StreamRegistry.instance();
        this.controllerServer = VertxFactory.newVertx().createNetServer();
        String serverBindAddress = PropertyUtil.get("server.bind.stream.address", Main.serverProperties, "localhost");
        int serverBindPort = Integer.parseInt(PropertyUtil.get("server.bind.stream.port", Main.serverProperties, "10002"));
        ((NetServer)this.controllerServer.connectHandler(new ServerConnectionHandler()).setTCPKeepAlive(true)).listen(serverBindPort, serverBindAddress);
        System.err.println("--- Streaming server listening for connections on " + serverBindAddress + ":" + serverBindPort);
    }

    private void parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i].toLowerCase()) {
                default: 
            }
        }
    }

    public class ServerConnectionHandler
    implements Handler<NetSocket> {
        @Override
        public void handle(NetSocket netSocket) {
            ClientConnection client = new ClientConnection(netSocket);
            ConnectionReadHandler readHandler = new ConnectionReadHandler(client);
            ConnectionCloseHandler closeHandler = new ConnectionCloseHandler(client);
            netSocket.dataHandler(readHandler);
            StreamServer.this.LOG.info("[Streaming] New connection: {}", (Object)netSocket);
        }
    }
}

