/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import net.scattersphere.job.registry.JobRegistry;
import net.scattersphere.server.ClientConnection;
import net.scattersphere.server.Main;
import net.scattersphere.server.handler.core.ConnectionCloseHandler;
import net.scattersphere.server.handler.core.ConnectionReadHandler;
import net.scattersphere.util.PropertyUtil;
import net.scattersphere.util.thread.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.NetSocket;

public class Server {
    private final NetServer controllerServer;
    private final Properties properties = new Properties();
    private final Logger LOG = LoggerFactory.getLogger(Server.class);

    public Server(String[] args) {
        if (args.length > 0) {
            this.parseArguments(args);
        }
        JobRegistry.instance();
        JobManager.instance();
        this.controllerServer = VertxFactory.newVertx().createNetServer();
        String serverBindAddress = PropertyUtil.get("server.bind.main.address", Main.serverProperties, "localhost");
        int serverBindPort = Integer.parseInt(PropertyUtil.get("server.bind.main.port", Main.serverProperties, "10001"));
        ((NetServer)this.controllerServer.connectHandler(new ServerConnectionHandler()).setTCPKeepAlive(true)).listen(serverBindPort, serverBindAddress);
        System.err.println("--- Main server listening for connections on " + serverBindAddress + ":" + serverBindPort);
    }

    private void showHelp() {
        System.err.println("Usage: server [arguments]");
        System.err.println("    -p [file]     Loads the specified properties file.");
        System.err.println("    -h/--help     Shows help.");
        System.err.println("    -v/--version  Shows version information.");
    }

    private void showVersion() {
        System.err.println("Version: " + Main.getRelease());
    }

    private void loadProperties(String file) throws Exception {
        this.properties.load(new FileInputStream(new File(file)));
        JobRegistry.instance().loadFromProperties(this.properties);
    }

    private void parseArguments(String[] args) {
        block14: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i].toLowerCase()) {
                case "-h": 
                case "--help": {
                    this.showHelp();
                    System.exit(0);
                }
                case "-v": 
                case "--version": {
                    this.showVersion();
                    System.exit(0);
                }
                case "-p": {
                    if (++i >= args.length) {
                        System.err.println("-p requires a filename.");
                        System.exit(-1);
                    }
                    try {
                        this.loadProperties(args[i]);
                        continue block14;
                    }
                    catch (Exception ex) {
                        System.err.println("*** Properties file could not be loaded: " + ex.getMessage());
                        ex.printStackTrace();
                        System.exit(-1);
                    }
                }
            }
        }
    }

    public class ServerConnectionHandler
    implements Handler<NetSocket> {
        @Override
        public void handle(NetSocket netSocket) {
            ClientConnection client = new ClientConnection(netSocket);
            ConnectionReadHandler readHandler = new ConnectionReadHandler(client);
            ConnectionCloseHandler closeHandler = new ConnectionCloseHandler(client);
            netSocket.dataHandler(readHandler);
            netSocket.closeHandler(closeHandler);
            Server.this.LOG.info("New connection: {}", (Object)netSocket);
        }
    }
}

