/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.server;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.net.NetSocket;

public class ClientConnection {
    private final NetSocket endpoint;
    private Buffer readBuffer;
    private long expectedPayloadSize;
    public static final long MAX_PAYLOAD = 16384L;

    public ClientConnection(NetSocket endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("No NetSocket object provided.");
        }
        this.endpoint = endpoint;
        this.readBuffer = new Buffer();
        this.expectedPayloadSize = 0L;
    }

    public NetSocket getEndpoint() {
        return this.endpoint;
    }

    public Buffer getReadBuffer() {
        return this.readBuffer;
    }

    public void clearReadBuffer() {
        this.readBuffer = new Buffer();
        this.setExpectedPayloadSize(0L);
    }

    public void setExpectedPayloadSize(long expectedPayloadSize) {
        this.expectedPayloadSize = expectedPayloadSize;
    }

    public long getExpectedPayloadSize() {
        return this.expectedPayloadSize;
    }
}

