/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.job.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.scattersphere.job.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRegistry {
    private static final JobRegistry instance = new JobRegistry();
    private Map<String, Class<? extends Job>> registry;
    private final Logger LOG = LoggerFactory.getLogger(JobRegistry.class);

    private JobRegistry() {
        this.registry = new HashMap<String, Class<? extends Job>>();
    }

    public static JobRegistry instance() {
        return instance;
    }

    public void loadFromProperties(Properties props) {
        int jobsCount;
        if (props.getProperty("jobs.count") == null) {
            this.LOG.error("Unable to initialize: job registry missing key \"jobs.count\"");
            System.exit(-1);
        }
        if ((jobsCount = Integer.parseInt(props.getProperty("jobs.count"))) <= 0) {
            this.LOG.error("Unable to initialize: invalid number of jobs: {}", (Object)jobsCount);
            System.exit(-1);
        }
        this.LOG.debug("Initializing job registry: jobsCount={}", (Object)jobsCount);
        int jobsRegistered = 0;
        int jobsWarned = 0;
        for (int i = 1; i < jobsCount + 1; ++i) {
            String jobClassname = props.getProperty("jobs." + i + ".classname");
            String jobName = props.getProperty("jobs." + i + ".name");
            if (jobClassname == null) {
                this.LOG.warn("Unable to start job at position {}: class name missing.", (Object)i);
                ++jobsWarned;
                continue;
            }
            if (jobName == null) {
                this.LOG.warn("Unable to start job at position {}: job name missing.", (Object)i);
                ++jobsWarned;
                continue;
            }
            Class<?> jobClass = null;
            try {
                jobClass = Class.forName(jobClassname);
            }
            catch (Exception ex) {
                this.LOG.error("Unable to start job at position {}: unable to find job in classpath: {}", i, jobClassname, ex);
                continue;
            }
            this.registry.put(jobName, jobClass);
            ++jobsRegistered;
        }
        this.LOG.info("*** Job Registry: registered={} skipped={}", (Object)jobsRegistered, (Object)jobsWarned);
    }

    public Job get(String job) {
        if (this.registry.get(job) == null) {
            this.LOG.debug("Unable to find job by name: {}", (Object)job);
            return null;
        }
        Class<? extends Job> jobClass = this.registry.get(job);
        Job jobObject = null;
        try {
            jobObject = jobClass.newInstance();
        }
        catch (Exception ex) {
            this.LOG.warn("Unable to create new instance of job: {}", (Object)job, (Object)ex);
            ex.printStackTrace();
        }
        return jobObject;
    }

    public Map<String, Class<? extends Job>> getJobs() {
        return this.registry;
    }
}

