/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.job.example;

import java.util.Date;
import net.scattersphere.job.AbstractJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sleep
extends AbstractJob {
    private static final int DEFAULT_SLEEPTIME = 30;
    private final Logger LOG = LoggerFactory.getLogger(Sleep.class);

    @Override
    public String getDescription() {
        return "Sleeps for a determinant amount of time, default 30 seconds.";
    }

    @Override
    public void run() {
        int sleepTime = 30;
        String[] arguments = this.getArguments();
        if (arguments != null && arguments.length > 0) {
            sleepTime = Integer.parseInt(arguments[0]);
        }
        if (sleepTime < 0) {
            throw new IllegalArgumentException("Sleep time must be a positive value.");
        }
        this.writeToStream(("Currently Sleeping for " + sleepTime + " second(s): started at " + new Date().toString()).getBytes());
        try {
            Thread.sleep(sleepTime * 1000);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.writeToStream("Sleep completed.".getBytes());
    }
}

