/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.job.example;

import net.scattersphere.job.AbstractJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Counter
extends AbstractJob {
    private final Logger LOG = LoggerFactory.getLogger(Counter.class);
    private static final int DEFAULT_COUNT = 60;
    private static final int ONE_SECOND = 1000;

    public Counter() {
        this.LOG.debug("Counter job instantiated.");
    }

    @Override
    public String getDescription() {
        return "Counts from 1 to (count), pausing 1 second between.";
    }

    @Override
    public void run() {
        Object timezone = null;
        String[] arguments = this.getArguments();
        int count = 60;
        if (arguments != null && arguments.length > 0) {
            count = Integer.parseInt(arguments[0]);
        }
        for (int i = 0; i < count; ++i) {
            try {
                Thread.sleep(1000L);
                this.writeToStream(("Counter: " + (i + 1)).getBytes());
                continue;
            }
            catch (Exception ex) {
                this.LOG.debug("Interrupted thread, exiting.");
                return;
            }
        }
        this.writeToStream("Counter job complete.".getBytes());
    }
}

