/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.job;

import net.scattersphere.job.Job;
import net.scattersphere.job.stream.StreamRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob
implements Job {
    private String[] arguments = null;
    private String jobId;
    private final Logger LOG = LoggerFactory.getLogger(AbstractJob.class);

    @Override
    public void prepare(String[] arguments) {
        this.arguments = arguments;
        this.LOG.info("Prepare: Set arguments={}", arguments);
        StreamRegistry.instance().openStream(this.jobId);
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void writeToStream(byte[] data) {
        StreamRegistry.instance().write(this.jobId, data);
    }

    public void closeStream() {
        StreamRegistry.instance().closeStream(this.jobId);
    }

    @Override
    public String getDescription() {
        return "No description provided.";
    }

    @Override
    public abstract void run();
}

