/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSerializer {
    public static final int PACKET_HEADER_SIZE = 4;

    public static byte[] serialize(Object obj) {
        Objects.requireNonNull(obj);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FSTObjectOutput foo = new FSTObjectOutput(baos);
        try {
            foo.writeObject(obj);
            foo.close();
            baos.close();
        }
        catch (Exception ex) {
            return null;
        }
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] data) {
        Objects.requireNonNull(data);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        FSTObjectInput ois = null;
        try {
            ois = new FSTObjectInput(bais);
            Object obj = ois.readObject();
            ois.close();
            bais.close();
            return obj;
        }
        catch (Exception ex) {
            Logger LOG = LoggerFactory.getLogger(DataSerializer.class);
            LOG.warn("Deserialize failed.", ex);
            return null;
        }
    }

    public static byte[] packetize(byte[] data) {
        Objects.requireNonNull(data);
        byte[] copiedData = new byte[data.length + 4];
        copiedData[0] = (byte)(0xFF & data.length >> 24);
        copiedData[1] = (byte)(0xFF & data.length >> 16);
        copiedData[2] = (byte)(0xFF & data.length >> 8);
        copiedData[3] = (byte)(0xFF & data.length);
        System.arraycopy(data, 0, copiedData, 4, data.length);
        return copiedData;
    }
}

