/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.app;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rapture.common.PluginConfig;
import rapture.common.PluginTransportItem;
import rapture.common.RaptureURI;
import rapture.common.client.CredentialsProvider;
import rapture.common.client.HttpLoginApi;
import rapture.common.client.ScriptClient;
import rapture.common.client.SimpleCredentialsProvider;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.kernel.ContextFactory;
import rapture.plugin.app.FileBasedSandboxLoader;
import rapture.plugin.app.JarBasedSandboxLoader;
import rapture.plugin.app.SandboxLoader;
import rapture.plugin.install.PluginSandbox;
import rapture.plugin.install.PluginSandboxItem;
import rapture.util.ResourceLoader;

public class SelfInstaller {
    public static final String ARG_HOST = "-host";
    public static final String ARG_USER = "-user";
    public static final String ARG_PASSWORD = "-password";
    public static final String ARG_AREA = "-area";
    public static final String ARG_OVERLAY = "-overlay";
    private String host = "http://localhost:8665/rapture";
    private String password = "rapture";
    private String username = "rapture";
    private String overlay = null;
    private boolean isFileBased = false;
    private String pluginArea;
    private PluginSandbox sandbox;

    private void processArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (ARG_HOST.equals(args[i])) {
                    this.host = args[++i];
                    continue;
                }
                if (ARG_USER.equals(args[i])) {
                    this.username = args[++i];
                    continue;
                }
                if (ARG_PASSWORD.equals(args[i])) {
                    this.password = args[++i];
                    continue;
                }
                if (ARG_AREA.equals(args[i])) {
                    this.pluginArea = args[++i];
                    continue;
                }
                if (!ARG_OVERLAY.equals(args[i])) continue;
                this.overlay = args[++i];
            }
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    public SelfInstaller(String pluginArea) {
        this.pluginArea = pluginArea;
    }

    public void loadSandbox() throws Exception {
        this.sandbox = new PluginSandbox();
        this.loadSandboxFromResources(this.sandbox, "/" + this.pluginArea);
    }

    public void installSandbox() {
        HashMap payload = Maps.newHashMap();
        String thisVariant = this.overlay;
        for (PluginSandboxItem item : this.sandbox.getItems(thisVariant)) {
            try {
                System.out.println("Packaging " + item.getURI().toString());
                PluginTransportItem payloadItem = item.makeTransportItem();
                RaptureURI uri = item.getURI();
                if (this.isFileBased && item.getFullFilePath() != null) {
                    uri = RaptureURI.builder((RaptureURI)uri).element(item.getFullFilePath()).build();
                    System.out.println("uri=" + uri);
                    payloadItem.setUri(uri.toString());
                }
                payload.put(uri.toString(), payloadItem);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        SimpleCredentialsProvider creds = new SimpleCredentialsProvider(this.username, this.password);
        HttpLoginApi login = new HttpLoginApi(this.host, (CredentialsProvider)creds);
        login.login();
        ScriptClient client = new ScriptClient(login);
        List list = client.getPlugin().getInstalledPlugins(ContextFactory.getKernelUser());
        for (PluginConfig cxt : list) {
            if (cxt.getPlugin() != this.sandbox.getPluginName()) continue;
            client.getPlugin().uninstallPlugin(this.sandbox.getPluginName());
        }
        client.getPlugin().installPlugin(this.sandbox.makeManifest(thisVariant), (Map)payload);
    }

    public static void main(String[] args) throws Exception {
        SelfInstaller installer = new SelfInstaller("PLUGIN");
        installer.processArgs(args);
        installer.loadSandbox();
        installer.installSandbox();
    }

    private void loadSandboxFromResources(PluginSandbox sandbox, String resourcePath) throws Exception {
        SandboxLoader loader;
        String pluginContent = ResourceLoader.getResourceAsString(SelfInstaller.class, (String)(resourcePath + "/" + "plugin.txt"));
        System.out.println("Plugin content is " + pluginContent);
        PluginConfig fConfig = (PluginConfig)JacksonUtil.objectFromJson((String)pluginContent, PluginConfig.class);
        sandbox.setConfig(fConfig);
        String rootPath = resourcePath + "/" + "content/";
        URL dirURL = SelfInstaller.class.getClass().getResource(rootPath);
        if ("jar".equals(dirURL.getProtocol())) {
            loader = new JarBasedSandboxLoader();
        } else {
            this.isFileBased = true;
            loader = new FileBasedSandboxLoader();
        }
        loader.loadSandboxFromEntries(rootPath, this.overlay, sandbox);
    }
}

