/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.app;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.tuple.Triple;
import rapture.common.RaptureURI;
import rapture.common.Scheme;
import rapture.plugin.app.SandboxLoader;
import rapture.plugin.app.SelfInstaller;
import rapture.plugin.install.PluginSandbox;
import rapture.plugin.install.PluginSandboxItem;

public class JarBasedSandboxLoader
implements SandboxLoader {
    @Override
    public void loadSandboxFromEntries(String root, String variant, PluginSandbox sandbox) throws Exception {
        String[] files;
        for (String f : files = this.getResourceFiles(root, variant)) {
            boolean isVariant = false;
            String path = "/" + f;
            System.out.println("Path is " + path);
            f = f.substring(7);
            if (f.startsWith("content/")) {
                f = f.substring("content/".length());
            } else if (f.startsWith(variant + "/")) {
                f = f.substring(variant.length() + 1);
                isVariant = true;
            }
            System.out.println("File is " + f);
            Triple trip = PluginSandboxItem.extractScheme((String)f);
            System.out.println("Triple is " + trip.toString());
            RaptureURI uri = RaptureURI.createFromFullPathWithAttribute((String)((String)trip.getLeft()), (String)((String)trip.getMiddle()), (Scheme)((Scheme)trip.getRight()));
            System.out.println("URI is " + uri.toString());
            sandbox.makeItemFromInternalEntry(uri, SelfInstaller.class.getResourceAsStream(path), isVariant ? variant : null);
        }
    }

    private String[] getResourceFiles(String path, String variant) throws Exception {
        String checkVariant;
        URL dirURL = SelfInstaller.class.getClass().getResource(path);
        String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
        JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        HashSet<String> result = new HashSet<String>();
        String checkPath = path.substring(1);
        String string = checkVariant = variant != null ? checkPath.replaceFirst("content/", variant).concat("/") : null;
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (name.endsWith("/") || !name.startsWith(checkPath) && (checkVariant == null || !name.startsWith(checkVariant))) continue;
            result.add(name);
        }
        jar.close();
        return result.toArray(new String[result.size()]);
    }
}

