/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.app;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import org.apache.commons.lang3.tuple.Triple;
import rapture.common.RaptureURI;
import rapture.common.Scheme;
import rapture.plugin.app.SandboxLoader;
import rapture.plugin.app.SelfInstaller;
import rapture.plugin.install.PluginSandbox;
import rapture.plugin.install.PluginSandboxItem;

public class FileBasedSandboxLoader
implements SandboxLoader {
    @Override
    public void loadSandboxFromEntries(String root, String part, PluginSandbox sandbox) throws Exception {
        String[] files;
        String area = root + part;
        System.out.println("From " + area);
        String[] folders = this.getResourceFolders(area);
        for (String f : files = this.getResourceFiles(area)) {
            String path = root + part + f;
            Triple trip = PluginSandboxItem.extractScheme((String)(part + f));
            RaptureURI uri = RaptureURI.createFromFullPathWithAttribute((String)((String)trip.getLeft()), (String)((String)trip.getMiddle()), (Scheme)((Scheme)trip.getRight()));
            String fileFullPath = SelfInstaller.class.getResource(path).getPath();
            System.out.println("File " + fileFullPath);
            sandbox.makeItemFromInternalEntry(uri, SelfInstaller.class.getResourceAsStream(path), fileFullPath, null);
        }
        for (String f : folders) {
            this.loadSandboxFromEntries(root, part + f + "/", sandbox);
        }
    }

    private String[] getResourceFolders(String path) throws Exception {
        URL dirURL = SelfInstaller.class.getClass().getResource(path);
        return new File(dirURL.toURI()).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        });
    }

    private String[] getResourceFiles(String path) throws Exception {
        URL dirURL = SelfInstaller.class.getClass().getResource(path);
        return new File(dirURL.toURI()).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isFile();
            }
        });
    }
}

