/*
 * Decompiled with CFR 0.152.
 */
package rapture.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeCache {
    private Node root = new Node("", true);
    private final Callback callback;

    public TreeCache(Callback callback) {
        this.callback = callback;
    }

    public void registerKey(String key) {
        boolean isFolder;
        String[] elements = TreeCache.massagePath(key).split("/");
        Node nut = this.root;
        int index = 0;
        boolean bl = isFolder = elements.length > 1;
        while (index < elements.length) {
            if (elements[index].length() == 0) {
                ++index;
                continue;
            }
            Node bolt = nut.find(elements[index]);
            if (bolt == null) {
                bolt = nut.add(elements[index], isFolder);
                this.callback.register(this.combine(elements, index), isFolder);
            } else if (!bolt.isLeaf() && !isFolder) {
                bolt.alsoLeaf();
                this.callback.register(this.combine(elements, index), false);
            } else if (!bolt.isFolder() && isFolder) {
                bolt.alsoFolder();
                this.callback.register(this.combine(elements, index), true);
            }
            nut = bolt;
            isFolder = ++index + 1 < elements.length;
        }
    }

    private String combine(String[] elements, int offset) {
        StringBuilder sb = new StringBuilder();
        sb.append(elements[0]);
        for (int i = 1; i < offset + 1; ++i) {
            sb.append("/");
            sb.append(elements[i]);
        }
        return sb.toString();
    }

    public void invalidateKey(String key) {
        this.unregisterKey(key, false, true);
        this.unregisterKey(key, true, true);
    }

    public void unregisterFolder(String key) {
        this.unregisterKey(key, true, false);
    }

    public void unregisterKey(String key) {
        this.unregisterKey(key, false, false);
    }

    public void unregisterKey(String key, boolean isFolder, boolean cacheOnly) {
        if (!cacheOnly) {
            this.callback.unregister(key, false);
        }
        ArrayList path = Lists.newArrayList();
        String[] elements = TreeCache.massagePath(key).split("/");
        Node nut = this.root;
        int index = 0;
        boolean notFirst = isFolder;
        while (index < elements.length) {
            if (elements[index].length() == 0) {
                ++index;
                continue;
            }
            Node bolt = nut.find(elements[index]);
            if (bolt == null) {
                notFirst = true;
                break;
            }
            path.add(bolt);
            nut = bolt;
            ++index;
        }
        for (int i = elements.length - 1; i >= 0; --i) {
            int j = i - 1;
            Node child = this.safeGet(path, i);
            Node parent = this.safeGet(path, j);
            if (child != null) {
                if (child.isFolder() && child.isLeaf()) {
                    if (notFirst) {
                        child.onlyFolder();
                    } else {
                        child.onlyLeaf();
                    }
                    return;
                }
                if (parent != null && parent.remove(elements[i], child)) {
                    return;
                }
            }
            notFirst = true;
        }
    }

    private Node safeGet(List<Node> list, int index) {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static String massagePath(String path) {
        return path.replaceAll("/+", "/").replaceAll("^/+", "").replaceAll("/$", "");
    }

    private static class ListMap<K, V>
    implements Map<K, V> {
        private List<Entry<K, V>> data = Lists.newArrayList();

        ListMap(K k, V v) {
            this.data.add(new Entry<K, V>(k, v));
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            for (Entry<K, V> e : this.data) {
                if (!e.getKey().equals(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            for (Entry<K, V> e : this.data) {
                if (!value.equals(e.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object key) {
            for (Entry<K, V> e : this.data) {
                if (!e.getKey().equals(key)) continue;
                return e.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            V result = this.get(key);
            this.data.add(new Entry<K, V>(key, value));
            return result;
        }

        @Override
        public V remove(Object key) {
            Iterator<Entry<K, V>> iter = this.data.iterator();
            while (iter.hasNext()) {
                Entry<K, V> e = iter.next();
                if (!key.equals(e.getKey())) continue;
                iter.remove();
                return e.getValue();
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            HashSet result = Sets.newHashSet();
            for (Entry<K, V> e : this.data) {
                result.add(e.getKey());
            }
            return result;
        }

        @Override
        public Collection<V> values() {
            HashSet result = Sets.newHashSet();
            for (Entry<K, V> e : this.data) {
                result.add(e.getValue());
            }
            return result;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            HashSet s = Sets.newHashSet();
            s.addAll(this.data);
            return s;
        }

        static class Entry<K, V>
        implements Map.Entry<K, V> {
            final K k;
            final V v;

            Entry(K k, V v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class Node {
        private boolean isFolder;
        private boolean isLeaf;
        private Map<String, Node> children = null;
        private static int HASH_THRESHOLD = 6;

        Node(String element, boolean isFolder) {
            this.isFolder = isFolder;
            this.isLeaf = !isFolder;
        }

        public synchronized boolean remove(String key, Node child) {
            if (child == null) {
                return this.size() > 0;
            }
            this.children.remove(key);
            return this.size() > 0;
        }

        public int size() {
            return this.children == null ? 0 : this.children.size();
        }

        public void onlyLeaf() {
            this.isFolder = false;
        }

        public void onlyFolder() {
            this.isLeaf = false;
        }

        public void alsoFolder() {
            this.isFolder = true;
        }

        public void alsoLeaf() {
            this.isLeaf = true;
        }

        Node find(String key) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(key);
        }

        synchronized Node add(String key, boolean isFolder) {
            Node result = new Node(key, isFolder);
            if (this.children == null) {
                this.children = new ListMap<String, Node>(key, result);
            } else if (this.children.size() == HASH_THRESHOLD) {
                Map<String, Node> old_kids = this.children;
                this.children = Maps.newHashMap();
                this.children.putAll(old_kids);
                this.children.put(key, result);
            } else {
                this.children.put(key, result);
            }
            return result;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    public static interface Callback {
        public void register(String var1, boolean var2);

        public void unregister(String var1, boolean var2);
    }
}

