/*
 * Decompiled with CFR 0.152.
 */
package rapture.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import rapture.common.exception.RaptureExceptionFactory;

public final class StringUtil {
    public static String[] firstSplit(String displayNamePart) {
        int firstPoint = displayNamePart.indexOf(47);
        String[] ret = new String[2];
        if (firstPoint == -1) {
            ret[0] = displayNamePart;
            ret[1] = null;
        } else {
            ret[0] = displayNamePart.substring(0, firstPoint);
            ret[1] = displayNamePart.substring(firstPoint + 1);
        }
        return ret;
    }

    public static String[] lastSplit(String displayNamePart) {
        int lastPoint = displayNamePart.lastIndexOf(47);
        String[] ret = new String[2];
        if (lastPoint == -1) {
            ret[0] = displayNamePart;
            ret[1] = null;
        } else {
            ret[0] = displayNamePart.substring(0, lastPoint);
            ret[1] = displayNamePart.substring(lastPoint + 1);
        }
        return ret;
    }

    public static List<List<String>> getBatches(List<String> displayNames, int batchSize) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        ArrayList<String> current = new ArrayList<String>();
        for (String display : displayNames) {
            current.add(display);
            if (current.size() < batchSize) continue;
            ret.add(current);
            current = new ArrayList();
        }
        if (!current.isEmpty()) {
            ret.add(current);
        }
        return ret;
    }

    public static Map<String, Object> getMapFromString(String val) {
        String[] parts;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (val == null || val.isEmpty()) {
            return ret;
        }
        for (String p : parts = val.split(",")) {
            String[] lr = p.split("=");
            if (lr.length != 2 || lr[0].isEmpty() || lr[1].isEmpty()) continue;
            ret.put(lr[0], lr[1]);
        }
        return ret;
    }

    public static Map<String, String> getStringMapFromString(String val) {
        String[] parts;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (val == null || val.isEmpty()) {
            return ret;
        }
        for (String p : parts = val.split(",")) {
            String[] lr = p.split("=");
            if (lr.length != 2 || lr[0].isEmpty() || lr[1].isEmpty()) continue;
            ret.put(lr[0], lr[1]);
        }
        return ret;
    }

    public static List<String> list(String val) {
        return StringUtil.list(val, ",");
    }

    public static List<String> list(String val, String string) {
        String[] parts;
        ArrayList<String> ret = new ArrayList<String>();
        if (val == null || val.isEmpty()) {
            return ret;
        }
        for (String p : parts = val.split(string)) {
            ret.add(p);
        }
        return ret;
    }

    private StringUtil() {
    }

    public static String base64Compress(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(content.getBytes("UTF-8"));
            gzip.close();
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error compressing content", (Throwable)e);
        }
        byte[] encoding = Base64.encodeBase64((byte[])out.toByteArray());
        return new String(encoding);
    }

    public static String base64Decompress(String content) {
        byte[] decodedBytes = Base64.decodeBase64((byte[])content.getBytes());
        ByteArrayInputStream is = new ByteArrayInputStream(decodedBytes);
        try {
            String line;
            GZIPInputStream gzip = new GZIPInputStream(is);
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gzip, "UTF-8"));
            StringBuilder ret = new StringBuilder();
            while ((line = bf.readLine()) != null) {
                ret.append(line);
                ret.append("\n");
            }
            return ret.toString().substring(0, ret.length() - 1);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error decompressing content", (Throwable)e);
        }
    }
}

