/*
 * Decompiled with CFR 0.152.
 */
package rapture.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MimeTypeResolver {
    private static Logger log = Logger.getLogger((String)MimeTypeResolver.class.getName());
    private Map<String, String> mimeTypes = new HashMap<String, String>();

    public MimeTypeResolver() {
        this.processResource("/mimeTypes.txt");
    }

    public String getExtensionFromPath(String path) {
        int indexPoint = path.lastIndexOf(46);
        String extension = path;
        if (indexPoint != -1) {
            extension = path.substring(indexPoint + 1);
        }
        return extension;
    }

    public String getMimeTypeFromPath(String path) {
        return this.getMimeType(this.getExtensionFromPath(path));
    }

    private void processResource(String path) {
        InputStream is = MimeTypeResolver.class.getResourceAsStream(path);
        if (is != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    String[] parts = line.split("\\s+");
                    for (int i = 1; i < parts.length; ++i) {
                        this.mimeTypes.put(parts[i], parts[0]);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String getMimeType(String extension) {
        if (this.mimeTypes.containsKey(extension)) {
            return this.mimeTypes.get(extension);
        }
        return "application/unknown";
    }
}

