/*
 * Decompiled with CFR 0.152.
 */
package rapture.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class FileStreamer
implements Iterable<String>,
Iterator<String> {
    private boolean used = false;
    private Scanner s;
    private String nextLine;

    public static final FileStreamer lines(String filename) throws FileNotFoundException {
        return FileStreamer.lines(new File(filename));
    }

    public static final FileStreamer lines(File f) throws FileNotFoundException {
        FileStreamer fs = new FileStreamer();
        fs.s = new Scanner(f);
        fs.next();
        return fs;
    }

    private FileStreamer() {
    }

    @Override
    public Iterator<String> iterator() {
        if (this.used) {
            throw new IllegalStateException("Cannot rewind input");
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public String next() {
        String result = this.nextLine;
        try {
            this.nextLine = this.s.nextLine();
        }
        catch (NoSuchElementException e) {
            this.nextLine = null;
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.s.close();
    }
}

