/*
 * Decompiled with CFR 0.152.
 */
package rapture.generated;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.runtime.tree.TreeParser;

public class JSONTree
extends TreeParser {
    public static final String[] tokenNames = new String[]{"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ARRAY", "COMMA", "Digit", "EscapeSequence", "Exponent", "FALSE", "FIELD", "HexDigit", "NULL", "NUMBER", "Number", "OBJECT", "STRING", "String", "TRUE", "UnicodeEscape", "WS", "':'", "'['", "']'", "'false'", "'null'", "'true'", "'{'", "'}'"};
    public static final int EOF = -1;
    public static final int T__21 = 21;
    public static final int T__22 = 22;
    public static final int T__23 = 23;
    public static final int T__24 = 24;
    public static final int T__25 = 25;
    public static final int T__26 = 26;
    public static final int T__27 = 27;
    public static final int T__28 = 28;
    public static final int ARRAY = 4;
    public static final int COMMA = 5;
    public static final int Digit = 6;
    public static final int EscapeSequence = 7;
    public static final int Exponent = 8;
    public static final int FALSE = 9;
    public static final int FIELD = 10;
    public static final int HexDigit = 11;
    public static final int NULL = 12;
    public static final int NUMBER = 13;
    public static final int Number = 14;
    public static final int OBJECT = 15;
    public static final int STRING = 16;
    public static final int String = 17;
    public static final int TRUE = 18;
    public static final int UnicodeEscape = 19;
    public static final int WS = 20;
    public static final BitSet FOLLOW_value_in_parse53 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_string_in_value78 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_number_in_value90 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_object_in_value102 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_array_in_value114 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TRUE_in_value124 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_FALSE_in_value134 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NULL_in_value144 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_STRING_in_string169 = new BitSet(new long[]{4L});
    public static final BitSet FOLLOW_String_in_string171 = new BitSet(new long[]{8L});
    public static final BitSet FOLLOW_OBJECT_in_object208 = new BitSet(new long[]{4L});
    public static final BitSet FOLLOW_pair_in_object210 = new BitSet(new long[]{1032L});
    public static final BitSet FOLLOW_NUMBER_in_number237 = new BitSet(new long[]{4L});
    public static final BitSet FOLLOW_Number_in_number239 = new BitSet(new long[]{264L});
    public static final BitSet FOLLOW_Exponent_in_number241 = new BitSet(new long[]{8L});
    public static final BitSet FOLLOW_ARRAY_in_array280 = new BitSet(new long[]{4L});
    public static final BitSet FOLLOW_value_in_array285 = new BitSet(new long[]{373272L});
    public static final BitSet FOLLOW_FIELD_in_pair312 = new BitSet(new long[]{4L});
    public static final BitSet FOLLOW_String_in_pair316 = new BitSet(new long[]{373264L});
    public static final BitSet FOLLOW_value_in_pair320 = new BitSet(new long[]{8L});

    public TreeParser[] getDelegates() {
        return new TreeParser[0];
    }

    public JSONTree(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }

    public JSONTree(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public String[] getTokenNames() {
        return tokenNames;
    }

    public String getGrammarFileName() {
        return "/Users/amkimian/Development/cloud/Rapture/Libs/RaptureCommon/src/main/antlr3/rapture/json/JSONTree.g";
    }

    private Object extractNumber(CommonTree numberToken, CommonTree exponentToken) {
        boolean isReal;
        String numberBody = numberToken.getText();
        String exponent = exponentToken == null ? null : exponentToken.getText().substring(1);
        boolean bl = isReal = numberBody.indexOf(46) >= 0 || exponent != null;
        if (!isReal) {
            return new Integer(numberBody);
        }
        double result = Double.parseDouble(numberBody);
        if (exponent != null) {
            result *= Math.pow(10.0, Double.parseDouble(exponent));
        }
        return new Double(result);
    }

    private String extractString(CommonTree token) {
        int slashIndex;
        StringBuffer sb = new StringBuffer(token.getText());
        int startPoint = 1;
        while ((slashIndex = sb.indexOf("\\", startPoint)) != -1) {
            char escapeType = sb.charAt(slashIndex + 1);
            switch (escapeType) {
                case 'u': {
                    String unicode = this.extractUnicode(sb, slashIndex);
                    sb.replace(slashIndex, slashIndex + 6, unicode);
                    break;
                }
                case 'b': {
                    sb.replace(slashIndex, slashIndex + 2, "\b");
                    break;
                }
                case 't': {
                    sb.replace(slashIndex, slashIndex + 2, "\t");
                    break;
                }
                case 'n': {
                    sb.replace(slashIndex, slashIndex + 2, "\n");
                    break;
                }
                case 'f': {
                    sb.replace(slashIndex, slashIndex + 2, "\f");
                    break;
                }
                case 'r': {
                    sb.replace(slashIndex, slashIndex + 2, "\r");
                    break;
                }
                case '\'': {
                    sb.replace(slashIndex, slashIndex + 2, "'");
                    break;
                }
                case '\"': {
                    sb.replace(slashIndex, slashIndex + 2, "\"");
                    break;
                }
                case '\\': {
                    sb.replace(slashIndex, slashIndex + 2, "\\");
                    break;
                }
                case '/': {
                    sb.replace(slashIndex, slashIndex + 2, "/");
                }
            }
            startPoint = slashIndex + 1;
        }
        sb.deleteCharAt(0);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String extractUnicode(StringBuffer sb, int slashIndex) {
        String result;
        String code = sb.substring(slashIndex + 2, slashIndex + 6);
        int charNum = Integer.parseInt(code, 16);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            osw.write(charNum);
            osw.flush();
            result = baos.toString("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object parse() throws RecognitionException {
        Object result = null;
        Object value1 = null;
        try {
            this.pushFollow(FOLLOW_value_in_parse53);
            value1 = this.value();
            --this.state._fsp;
            result = value1;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object value() throws RecognitionException {
        Object result = null;
        String s = null;
        Object n = null;
        Map<String, Object> o = null;
        List a = null;
        try {
            int alt1 = 7;
            switch (this.input.LA(1)) {
                case 16: {
                    alt1 = 1;
                    break;
                }
                case 13: {
                    alt1 = 2;
                    break;
                }
                case 15: {
                    alt1 = 3;
                    break;
                }
                case 4: {
                    alt1 = 4;
                    break;
                }
                case 18: {
                    alt1 = 5;
                    break;
                }
                case 9: {
                    alt1 = 6;
                    break;
                }
                case 12: {
                    alt1 = 7;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 1, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt1) {
                case 1: {
                    this.pushFollow(FOLLOW_string_in_value78);
                    s = this.string();
                    --this.state._fsp;
                    result = s;
                    break;
                }
                case 2: {
                    this.pushFollow(FOLLOW_number_in_value90);
                    n = this.number();
                    --this.state._fsp;
                    result = n;
                    break;
                }
                case 3: {
                    this.pushFollow(FOLLOW_object_in_value102);
                    o = this.object();
                    --this.state._fsp;
                    result = o;
                    break;
                }
                case 4: {
                    this.pushFollow(FOLLOW_array_in_value114);
                    a = this.array();
                    --this.state._fsp;
                    result = a;
                    break;
                }
                case 5: {
                    this.match((IntStream)this.input, 18, FOLLOW_TRUE_in_value124);
                    result = Boolean.TRUE;
                    break;
                }
                case 6: {
                    this.match((IntStream)this.input, 9, FOLLOW_FALSE_in_value134);
                    result = Boolean.FALSE;
                    break;
                }
                case 7: {
                    this.match((IntStream)this.input, 12, FOLLOW_NULL_in_value144);
                    result = null;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String string() throws RecognitionException {
        String result = null;
        CommonTree String2 = null;
        try {
            this.match((IntStream)this.input, 16, FOLLOW_STRING_in_string169);
            this.match((IntStream)this.input, 2, null);
            String2 = (CommonTree)this.match((IntStream)this.input, 17, FOLLOW_String_in_string171);
            this.match((IntStream)this.input, 3, null);
            result = this.extractString(String2);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Object> object() throws RecognitionException {
        HashMap<String, Object> result = null;
        result = new HashMap<String, Object>();
        try {
            this.match((IntStream)this.input, 15, FOLLOW_OBJECT_in_object208);
            this.match((IntStream)this.input, 2, null);
            int cnt2 = 0;
            block7: while (true) {
                int alt2 = 2;
                int LA2_0 = this.input.LA(1);
                if (LA2_0 == 10) {
                    alt2 = 1;
                }
                switch (alt2) {
                    case 1: {
                        this.pushFollow(FOLLOW_pair_in_object210);
                        this.pair(result);
                        --this.state._fsp;
                        break;
                    }
                    default: {
                        if (cnt2 >= 1) break block7;
                        EarlyExitException eee = new EarlyExitException(2, (IntStream)this.input);
                        throw eee;
                    }
                }
                ++cnt2;
            }
            this.match((IntStream)this.input, 3, null);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object number() throws RecognitionException {
        Object result = null;
        CommonTree Number3 = null;
        CommonTree Exponent4 = null;
        try {
            this.match((IntStream)this.input, 13, FOLLOW_NUMBER_in_number237);
            this.match((IntStream)this.input, 2, null);
            Number3 = (CommonTree)this.match((IntStream)this.input, 14, FOLLOW_Number_in_number239);
            int alt3 = 2;
            int LA3_0 = this.input.LA(1);
            if (LA3_0 == 8) {
                alt3 = 1;
            }
            switch (alt3) {
                case 1: {
                    Exponent4 = (CommonTree)this.match((IntStream)this.input, 8, FOLLOW_Exponent_in_number241);
                }
            }
            this.match((IntStream)this.input, 3, null);
            result = this.extractNumber(Number3, Exponent4);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List array() throws RecognitionException {
        ArrayList<Object> list = null;
        Object v = null;
        list = new ArrayList<Object>();
        try {
            this.match((IntStream)this.input, 4, FOLLOW_ARRAY_in_array280);
            this.match((IntStream)this.input, 2, null);
            int cnt4 = 0;
            block7: while (true) {
                int alt4 = 2;
                int LA4_0 = this.input.LA(1);
                if (LA4_0 == 4 || LA4_0 == 9 || LA4_0 >= 12 && LA4_0 <= 13 || LA4_0 >= 15 && LA4_0 <= 16 || LA4_0 == 18) {
                    alt4 = 1;
                }
                switch (alt4) {
                    case 1: {
                        this.pushFollow(FOLLOW_value_in_array285);
                        v = this.value();
                        --this.state._fsp;
                        list.add(v);
                        break;
                    }
                    default: {
                        if (cnt4 >= 1) break block7;
                        EarlyExitException eee = new EarlyExitException(4, (IntStream)this.input);
                        throw eee;
                    }
                }
                ++cnt4;
            }
            this.match((IntStream)this.input, 3, null);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pair(Map map) throws RecognitionException {
        CommonTree key = null;
        Object v = null;
        try {
            this.match((IntStream)this.input, 10, FOLLOW_FIELD_in_pair312);
            this.match((IntStream)this.input, 2, null);
            key = (CommonTree)this.match((IntStream)this.input, 17, FOLLOW_String_in_pair316);
            this.pushFollow(FOLLOW_value_in_pair320);
            v = this.value();
            --this.state._fsp;
            this.match((IntStream)this.input, 3, null);
            map.put(this.extractString(key), v);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
    }
}

