/*
 * Decompiled with CFR 0.152.
 */
package rapture.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import rapture.common.exception.ExceptionToString;
import rapture.config.EnvironmentValueReader;
import rapture.config.SystemPropertyValueReader;
import rapture.config.ValueReader;

public class ParameterValueReader
implements ValueReader {
    private static Logger log = Logger.getLogger(ParameterValueReader.class);
    Map<String, String> envMap;
    Map<String, String> propMap;
    String[] args;
    CommandLine line = null;
    EnvironmentValueReader envReader = new EnvironmentValueReader();
    SystemPropertyValueReader propReader = new SystemPropertyValueReader();
    Options options = new Options();

    public ParameterValueReader(String[] args) {
        this.args = args;
        this.envMap = new HashMap<String, String>();
        this.propMap = new HashMap<String, String>();
    }

    public void addMapping(String opt, boolean hasArg, String description, String envVar, String property) {
        if (envVar != null) {
            this.envMap.put(opt, envVar);
        }
        if (this.propMap != null) {
            this.propMap.put(opt, property);
        }
        this.options.addOption(opt, hasArg, description);
        this.line = null;
    }

    @Override
    public String getValue(String parameter) {
        String propName;
        String envName;
        String value = null;
        try {
            if (this.line == null) {
                this.line = new PosixParser().parse(this.options, this.args);
            }
            if (this.line.hasOption(parameter)) {
                value = this.line.getOptionValue(parameter, "");
            }
        }
        catch (ParseException e) {
            log.debug((Object)("cannot parse command line options " + e.getMessage()));
            log.trace((Object)ExceptionToString.format(e));
            e.printStackTrace();
        }
        if (value == null && (envName = this.envMap.get(parameter)) != null) {
            value = this.envReader.getValue(envName);
        }
        if (value == null && (propName = this.propMap.get(parameter)) != null) {
            value = this.envReader.getValue(propName);
        }
        return value;
    }
}

