/*
 * Decompiled with CFR 0.152.
 */
package rapture.common.impl.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.MapperFactory;

public final class JacksonUtil {
    private static final Logger log = Logger.getLogger(JacksonUtil.class);
    public static final ObjectMapper DEFAULT_MAPPER = MapperFactory.createDefault();
    private static final ObjectWriter PRETTY_PRINTER = DEFAULT_MAPPER.writerWithDefaultPrettyPrinter();

    public static Map<String, Object> getHashFromObject(Object obj) {
        return JacksonUtil.getMapFromJson(JacksonUtil.jsonFromObject(obj));
    }

    public static Map<String, Object> getMapFromJson(String json) {
        try {
            JsonFactory factory = new JsonFactory();
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)DEFAULT_MAPPER.readValue(factory.createJsonParser(json), (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error parsing json content " + json, (Throwable)e);
        }
    }

    public static Map<String, Object> getMapFromJson(InputStream json) {
        try {
            JsonFactory factory = new JsonFactory();
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)DEFAULT_MAPPER.readValue(factory.createJsonParser(json), (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error parsing json content " + json, (Throwable)e);
        }
    }

    public static String jsonFromObject(Object object) {
        StringWriter writer = new StringWriter();
        try {
            DEFAULT_MAPPER.writeValue((Writer)writer, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static byte[] bytesJsonFromObject(Object object) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DEFAULT_MAPPER.writeValue((OutputStream)os, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return os.toByteArray();
    }

    public static <T> T objectFromJson(JsonNode json, Class<T> klass) {
        Object object;
        if (klass == null) {
            throw RaptureExceptionFactory.create("Null class given to objectFromJson");
        }
        try {
            object = DEFAULT_MAPPER.convertValue((Object)json, klass);
        }
        catch (RuntimeException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error making " + klass.getName() + " object from json " + json, (Throwable)e);
        }
        return (T)object;
    }

    public static <T> T objectFromJson(String json, Class<T> klass) {
        Object object;
        try {
            object = DEFAULT_MAPPER.readValue(json, klass);
        }
        catch (IOException | RuntimeException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error making " + klass.getName() + " object from json " + json, (Throwable)e);
        }
        return (T)object;
    }

    public static <T> T objectFromJson(String json, TypeReference<T> tr) {
        Object object;
        try {
            object = DEFAULT_MAPPER.readValue(json, tr);
        }
        catch (IOException | RuntimeException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error parsing json content from TR " + json, (Throwable)e);
        }
        return (T)object;
    }

    public static String prettyfy(String json) {
        JsonNode node = JacksonUtil.treeFromJson(json);
        try {
            return PRETTY_PRINTER.writeValueAsString((Object)node);
        }
        catch (Exception e) {
            log.error((Object)("error printing json: " + ExceptionToString.format(e)));
            return json;
        }
    }

    public static JsonNode treeFromJson(String json) {
        try {
            return DEFAULT_MAPPER.readTree(json);
        }
        catch (IOException | RuntimeException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error parsing json content " + json, (Throwable)e);
        }
    }

    public static <T> T objectFromJson(byte[] jsonBytes, Class<T> klass) {
        return JacksonUtil.objectFromJson(new String(jsonBytes, Charsets.UTF_8), klass);
    }

    private JacksonUtil() {
    }
}

