/*
 * Decompiled with CFR 0.152.
 */
package rapture.common.exception;

import org.apache.log4j.Logger;
import rapture.common.Formattable;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureException;
import rapture.util.IDGenerator;

public class RaptureExceptionFactory {
    private static final Logger log = Logger.getLogger(RaptureExceptionFactory.class);

    public static RaptureException create(Integer status, Formattable message, Throwable cause) {
        String id = IDGenerator.getUUID();
        RaptureException e = new RaptureException(id, status, message.format(), cause);
        if (log.isTraceEnabled()) {
            log.trace((Object)ExceptionToString.format(e));
        }
        return e;
    }

    public static RaptureException create(Integer status, Formattable message) {
        return RaptureExceptionFactory.create(status, message, null);
    }

    public static RaptureException create(Formattable message, Throwable cause) {
        return RaptureExceptionFactory.create((Integer)500, message, cause);
    }

    public static RaptureException create(Formattable message) {
        return RaptureExceptionFactory.create((Integer)500, message, null);
    }

    public static RaptureException create(Integer status, String message, Throwable cause) {
        String id = IDGenerator.getUUID();
        RaptureException e = new RaptureException(id, status, message, cause);
        if (log.isTraceEnabled()) {
            log.trace((Object)ExceptionToString.format(e));
        }
        return e;
    }

    public static RaptureException create(Integer status, String message) {
        return RaptureExceptionFactory.create(status, message, null);
    }

    public static RaptureException create(String message) {
        return RaptureExceptionFactory.create((Integer)500, message, null);
    }

    public static RaptureException create(String message, Throwable cause) {
        return RaptureExceptionFactory.create((Integer)500, message, cause);
    }
}

