/*
 * Decompiled with CFR 0.152.
 */
package rapture.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import rapture.common.MessageFormat;

public class Messages {
    private static final String BUNDLE_NAME = "rapture.kernel.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("rapture.kernel.messages");
    private static Logger logger = Logger.getLogger(Messages.class);
    private static final HashMap<Locale, ResourceBundle> resourceBundles = new HashMap();
    private static String Separator = ".";
    private String module = null;
    private Locale locale = null;

    public Messages() {
        this(null, Locale.getDefault());
    }

    public Messages(String module) {
        this(module, Locale.getDefault());
    }

    public Messages(Locale locale) {
        this(null, locale);
    }

    public Messages(String module, Locale locale) {
        this.module = module;
        this.locale = locale;
    }

    public MessageFormat getMessage(String error) {
        return Messages.getMessage(this.module, error, null, this.locale);
    }

    public MessageFormat getMessage(String error, Object[] parameters) {
        return Messages.getMessage(this.module, error, parameters, this.locale);
    }

    public MessageFormat getMessage(String error, String parameter) {
        return Messages.getMessage(this.module, error, new Object[]{parameter}, this.locale);
    }

    public static MessageFormat getMessage(String module, String error, Object[] parameters, Locale locale) {
        String messageTemplate;
        ResourceBundle rb = Messages.findBundle(locale, BUNDLE_NAME);
        String messageRef = module + Separator + error;
        try {
            messageTemplate = rb.getString(messageRef);
        }
        catch (MissingResourceException mre) {
            try {
                messageTemplate = RESOURCE_BUNDLE.getString(messageRef);
            }
            catch (MissingResourceException mre2) {
                messageTemplate = mre2.getLocalizedMessage();
            }
        }
        if (messageTemplate == null) {
            messageTemplate = "Cannot find message {0} for {1} locale";
            parameters = new Object[]{messageRef, locale == null ? "default " : locale.getDisplayName()};
        }
        return new MessageFormat(messageTemplate, parameters, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findBundle(Locale locale, String catalog) throws MissingResourceException {
        ResourceBundle bundle = null;
        if (locale != null && (bundle = resourceBundles.get(locale)) == null) {
            HashMap<Locale, ResourceBundle> hashMap = resourceBundles;
            synchronized (hashMap) {
                try {
                    bundle = ResourceBundle.getBundle(catalog, locale);
                    resourceBundles.put(locale, bundle);
                }
                catch (MissingResourceException e) {
                    logger.warn((Object)(e.getMessage() + " - ignoring locale"));
                }
            }
        }
        return bundle == null ? RESOURCE_BUNDLE : bundle;
    }

    @Deprecated
    public static String getString(String key) {
        String[] keys = key.split("\\.");
        return Messages.getMessage(keys[0], keys[1], null, Locale.getDefault()).format();
    }
}

