/*
 * Decompiled with CFR 0.152.
 */
package rapture.exchange.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import org.apache.log4j.Logger;
import rapture.exchange.TopicMessageHandler;

public class SubscriptionThread
extends Thread {
    private static Logger logger = Logger.getLogger(SubscriptionThread.class);
    private QueueingConsumer consumer;
    private String exchange;
    private String topic;
    private Channel channel;
    private TopicMessageHandler handler;
    private boolean closeMe = false;

    public SubscriptionThread(String exchange, String topic, Channel channel, TopicMessageHandler handler) {
        this.channel = channel;
        this.exchange = exchange;
        this.topic = topic;
        this.handler = handler;
    }

    public boolean closeSubscription() {
        this.closeMe = true;
        return true;
    }

    @Override
    public void run() {
        logger.info((Object)("Running subscription thread for " + this.exchange + "," + this.topic));
        try {
            String queueName = this.channel.queueDeclare().getQueue();
            logger.info((Object)("Queue is " + queueName));
            this.channel.queueBind(queueName, this.exchange, this.topic);
            QueueingConsumer consumer = new QueueingConsumer(this.channel);
            this.channel.basicConsume(queueName, true, (Consumer)consumer);
            do {
                QueueingConsumer.Delivery delivery;
                if ((delivery = consumer.nextDelivery(500L)) == null) continue;
                String message = new String(delivery.getBody());
                String sentTopic = delivery.getEnvelope().getRoutingKey();
                try {
                    this.handler.deliverMessage(this.exchange, this.topic, sentTopic, message);
                }
                catch (Exception e) {
                    logger.info((Object)"Socket closed");
                    this.closeMe = true;
                }
            } while (!this.closeMe);
            logger.info((Object)"Stopping subscription thread");
            this.channel.queueDelete(queueName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ShutdownSignalException e) {
            e.printStackTrace();
        }
        catch (ConsumerCancelledException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

