/*
 * Decompiled with CFR 0.152.
 */
package rapture.exchange.rabbitmq;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import rapture.common.RapturePipelineTask;
import rapture.common.exception.ExceptionToString;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.config.MultiValueConfigLoader;
import rapture.exchange.QueueHandler;
import rapture.exchange.rabbitmq.Messages;

public class MessageConsumer
extends DefaultConsumer {
    private static Logger log = Logger.getLogger(MessageConsumer.class);
    private QueueHandler handler;
    private String tag;
    private ExecutorService service;

    public MessageConsumer(Channel channel, String tag, QueueHandler handler, String queueName) {
        super(channel);
        this.tag = tag;
        this.handler = handler;
        String threadPoolSizeString = MultiValueConfigLoader.getConfig((String)"RUNNER-rabbitMQConsumerPoolSize", (String)"50");
        int threadPoolSize = Integer.parseInt(threadPoolSizeString);
        this.service = Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat("MessageConsumer-" + queueName + "-%d").build());
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        final String routingKey = envelope.getRoutingKey();
        final String contentType = properties.getContentType();
        final long deliveryTag = envelope.getDeliveryTag();
        log.debug((Object)String.format(Messages.getString("RabbitExchangeHandler.receivedMessage"), deliveryTag));
        final RapturePipelineTask task = (RapturePipelineTask)JacksonUtil.objectFromJson((String)new String(body), RapturePipelineTask.class);
        log.debug((Object)Messages.getString("RabbitExchangeHandler.PlacingTask"));
        try {
            this.service.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block10: {
                        boolean ret = MessageConsumer.this.handler.handleMessage(MessageConsumer.this.tag, routingKey, contentType, task);
                        log.debug((Object)String.format(Messages.getString("RabbitExchangeHandler.acknowledgeMessage"), ret));
                        try {
                            MessageConsumer.this.getChannel().basicAck(deliveryTag, false);
                        }
                        catch (IOException e) {
                            log.error((Object)String.format("Error while acknowledging message with tag '%s':\n%s", deliveryTag, ExceptionToString.format((Throwable)e)));
                        }
                        break block10;
                        catch (Exception e) {
                            try {
                                log.error((Object)String.format(Messages.getString("RabbitExchangeHandler.noAcknowledge"), ExceptionToString.format((Throwable)e)));
                            }
                            catch (Throwable throwable) {
                                try {
                                    MessageConsumer.this.getChannel().basicAck(deliveryTag, false);
                                }
                                catch (IOException e2) {
                                    log.error((Object)String.format("Error while acknowledging message with tag '%s':\n%s", deliveryTag, ExceptionToString.format((Throwable)e2)));
                                }
                                throw throwable;
                            }
                            try {
                                MessageConsumer.this.getChannel().basicAck(deliveryTag, false);
                            }
                            catch (IOException e3) {
                                log.error((Object)String.format("Error while acknowledging message with tag '%s':\n%s", deliveryTag, ExceptionToString.format((Throwable)e3)));
                            }
                        }
                    }
                    log.debug((Object)Messages.getString("RabbitExchangeHandler.deliveryHandled"));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

