/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.service;

import java.util.List;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.service.ServiceWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InternalEventLoopServiceWrapper<O>
implements ServiceWrapper,
EventHandler {
    @NotNull
    protected final MethodReader[] serviceIn;
    private final HandlerPriority priority;
    @NotNull
    private final ChronicleQueue[] inputQueues;
    @NotNull
    private final ChronicleQueue outputQueue;
    @NotNull
    private final O serviceOut;
    private final boolean createdEventLoop;
    private final Object[] serviceImpl;
    private volatile boolean closed = false;
    @Nullable
    private EventLoop eventLoop;

    InternalEventLoopServiceWrapper(@NotNull ServiceWrapper.Builder<O> builder) {
        this.priority = builder.priority();
        this.outputQueue = ChronicleQueue.singleBuilder(builder.outputPath()).sourceId(builder.outputSourceId()).checkInterrupts(false).build();
        this.serviceOut = this.outputQueue.acquireAppender().methodWriterBuilder(builder.outClass()).get();
        this.serviceImpl = builder.getServiceFunctions().stream().map(f -> f.apply(this.serviceOut)).toArray();
        List<String> paths = builder.inputPath();
        this.serviceIn = new MethodReader[paths.size()];
        this.inputQueues = new ChronicleQueue[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            this.inputQueues[i] = ChronicleQueue.singleBuilder(paths.get(i)).sourceId(builder.inputSourceId()).build();
            this.serviceIn[i] = this.inputQueues[i].createTailer().afterLastWritten(this.outputQueue).methodReader(this.serviceImpl);
        }
        this.eventLoop = builder.eventLoop();
        this.eventLoop.addHandler((EventHandler)this);
        this.createdEventLoop = builder.createdEventLoop();
        if (this.createdEventLoop) {
            this.eventLoop.start();
        }
    }

    @Override
    @NotNull
    public ChronicleQueue[] inputQueues() {
        return this.inputQueues;
    }

    @Override
    @NotNull
    public ChronicleQueue outputQueue() {
        return this.outputQueue;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (this.isClosed()) {
            Closeable.closeQuietly((Object[])this.serviceImpl);
            Closeable.closeQuietly((Object[])this.serviceIn);
            Closeable.closeQuietly((Object)this.outputQueue);
            Closeable.closeQuietly((Object[])this.inputQueues);
            throw InvalidEventHandlerException.reusable();
        }
        boolean busy = false;
        for (MethodReader reader : this.serviceIn) {
            busy |= reader.readOne();
        }
        return busy;
    }

    @NotNull
    public HandlerPriority priority() {
        return this.priority;
    }

    public void close() {
        this.closed = true;
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop != null) {
            eventLoop.unpause();
        }
        this.eventLoop = null;
        if (this.createdEventLoop && eventLoop != null) {
            eventLoop.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

