/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.api.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.leadware.persistence.tools.api.utils.restrictions.Predicate;
import net.leadware.persistence.tools.api.utils.restrictions.impl.Eq;
import net.leadware.persistence.tools.api.utils.restrictions.impl.Ge;
import net.leadware.persistence.tools.api.utils.restrictions.impl.Gt;
import net.leadware.persistence.tools.api.utils.restrictions.impl.IsFalse;
import net.leadware.persistence.tools.api.utils.restrictions.impl.IsNotNull;
import net.leadware.persistence.tools.api.utils.restrictions.impl.IsNull;
import net.leadware.persistence.tools.api.utils.restrictions.impl.IsTrue;
import net.leadware.persistence.tools.api.utils.restrictions.impl.Le;
import net.leadware.persistence.tools.api.utils.restrictions.impl.Like;
import net.leadware.persistence.tools.api.utils.restrictions.impl.Lt;
import net.leadware.persistence.tools.api.utils.restrictions.impl.NotEq;
import net.leadware.persistence.tools.api.utils.restrictions.impl.NotLike;

public class RestrictionsContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Predicate> restrictions = new ArrayList<Predicate>();

    public static RestrictionsContainer newInstance() {
        return new RestrictionsContainer();
    }

    public RestrictionsContainer add(Predicate restriction) {
        if (restriction != null) {
            this.restrictions.add(restriction);
        }
        return this;
    }

    public <Y extends Comparable<? super Y>> RestrictionsContainer addEq(String property, Y value) {
        this.restrictions.add(new Eq<Y>(property, value));
        return this;
    }

    public <Y extends Comparable<? super Y>> RestrictionsContainer addNotEq(String property, Y value) {
        this.restrictions.add(new NotEq<Y>(property, value));
        return this;
    }

    public <Y extends Comparable<? super Y>> RestrictionsContainer addGe(String property, Y value) {
        this.restrictions.add(new Ge<Y>(property, value));
        return this;
    }

    public <Y extends Comparable<? super Y>> RestrictionsContainer addGt(String property, Y value) {
        this.restrictions.add(new Gt<Y>(property, value));
        return this;
    }

    public <Y extends Comparable<? super Y>> RestrictionsContainer addLt(String property, Y value) {
        this.restrictions.add(new Lt<Y>(property, value));
        return this;
    }

    public RestrictionsContainer addLike(String property, String value) {
        this.restrictions.add(new Like(property, value));
        return this;
    }

    public RestrictionsContainer addNotLike(String property, String value) {
        this.restrictions.add(new NotLike(property, value));
        return this;
    }

    public <Y extends Comparable<? super Y>> RestrictionsContainer addLe(String property, Y value) {
        this.restrictions.add(new Le<Y>(property, value));
        return this;
    }

    public RestrictionsContainer addIsFalse(String property) {
        this.restrictions.add(new IsFalse(property));
        return this;
    }

    public RestrictionsContainer addIsTrue(String property) {
        this.restrictions.add(new IsTrue(property));
        return this;
    }

    public RestrictionsContainer addIsNotNull(String property) {
        this.restrictions.add(new IsNotNull(property));
        return this;
    }

    public RestrictionsContainer addIsNull(String property) {
        this.restrictions.add(new IsNull(property));
        return this;
    }

    public List<Predicate> getRestrictions() {
        return Collections.unmodifiableList(this.restrictions);
    }

    public int size() {
        return this.restrictions.size();
    }

    public void clear() {
        if (this.restrictions != null) {
            this.restrictions.clear();
        }
    }
}

