/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.quartz.jobstore;

import com.google.common.base.Splitter;
import java.util.List;
import net.joelinn.quartz.jobstore.RedisTriggerState;
import org.quartz.JobKey;
import org.quartz.TriggerKey;

public class RedisJobStoreSchema {
    protected static final String DEFAULT_DELIMITER = ":";
    protected static final String JOBS_SET = "jobs";
    protected static final String JOB_GROUPS_SET = "job_groups";
    protected static final String LOCK = "lock";
    protected final String prefix;
    protected final String delimiter;

    public RedisJobStoreSchema() {
        this("");
    }

    public RedisJobStoreSchema(String prefix) {
        this(prefix, DEFAULT_DELIMITER);
    }

    public RedisJobStoreSchema(String prefix, String delimiter) {
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    public String lockKey() {
        return this.addPrefix(LOCK);
    }

    public String jobsSet() {
        return this.addPrefix(JOBS_SET);
    }

    public String jobGroupsSet() {
        return this.addPrefix(JOB_GROUPS_SET);
    }

    public String jobHashKey(JobKey jobKey) {
        return this.addPrefix("job" + this.delimiter + jobKey.getGroup() + this.delimiter + jobKey.getName());
    }

    public String jobDataMapHashKey(JobKey jobKey) {
        return this.addPrefix("job_data_map" + this.delimiter + jobKey.getGroup() + this.delimiter + jobKey.getName());
    }

    public String jobGroupSetKey(JobKey jobKey) {
        return this.addPrefix("job_group" + this.delimiter + jobKey.getGroup());
    }

    public JobKey jobKey(String jobHashKey) {
        List hashParts = Splitter.on((String)this.delimiter).splitToList((CharSequence)jobHashKey);
        return new JobKey((String)hashParts.get(2), (String)hashParts.get(1));
    }

    public String jobGroup(String jobGroupSetKey) {
        return (String)Splitter.on((String)this.delimiter).splitToList((CharSequence)jobGroupSetKey).get(1);
    }

    public String jobTriggersSetKey(JobKey jobKey) {
        return this.addPrefix("job_triggers" + this.delimiter + jobKey.getGroup() + this.delimiter + jobKey.getName());
    }

    public String blockedJobsSet() {
        return this.addPrefix("blocked_jobs");
    }

    public String triggerHashKey(TriggerKey triggerKey) {
        return this.addPrefix("trigger" + this.delimiter + triggerKey.getGroup() + this.delimiter + triggerKey.getName());
    }

    public TriggerKey triggerKey(String triggerHashKey) {
        List hashParts = Splitter.on((String)this.delimiter).splitToList((CharSequence)triggerHashKey);
        return new TriggerKey((String)hashParts.get(2), (String)hashParts.get(1));
    }

    public String triggerGroup(String triggerGroupSetKey) {
        return (String)Splitter.on((String)this.delimiter).splitToList((CharSequence)triggerGroupSetKey).get(1);
    }

    public String triggerGroupSetKey(TriggerKey triggerKey) {
        return this.addPrefix("trigger_group" + this.delimiter + triggerKey.getGroup());
    }

    public String triggersSet() {
        return this.addPrefix("triggers");
    }

    public String triggerGroupsSet() {
        return this.addPrefix("trigger_groups");
    }

    public String pausedTriggerGroupsSet() {
        return this.addPrefix("paused_trigger_groups");
    }

    public String triggerStateKey(RedisTriggerState state) {
        return this.addPrefix(state.getKey());
    }

    public String triggerLockKey(TriggerKey triggerKey) {
        return this.addPrefix("trigger_lock" + this.delimiter + triggerKey.getGroup() + this.delimiter + triggerKey.getName());
    }

    public String jobBlockedKey(JobKey jobKey) {
        return this.addPrefix("job_blocked" + this.delimiter + jobKey.getGroup() + this.delimiter + jobKey.getName());
    }

    public String lastTriggerReleaseTime() {
        return this.addPrefix("last_triggers_release_time");
    }

    public String pausedJobGroupsSet() {
        return this.addPrefix("paused_job_groups");
    }

    public String calendarTriggersSetKey(String calendarName) {
        return this.addPrefix("calendar_triggers" + this.delimiter + calendarName);
    }

    public String calendarHashKey(String calendarName) {
        return this.addPrefix("calendar" + this.delimiter + calendarName);
    }

    public String calendarName(String calendarHashKey) {
        return (String)Splitter.on((String)this.delimiter).splitToList((CharSequence)calendarHashKey).get(1);
    }

    public String calendarsSet() {
        return this.addPrefix("calendars");
    }

    protected String addPrefix(String key) {
        return this.prefix + key;
    }
}

