/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockProvider
implements LockProvider {
    private static final String KEY_PREFIX_DEFAULT = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final ShedlockRedisTemplate redisTemplate;
    private final String environment;
    private final String keyPrefix;

    public RedisLockProvider(@NotNull RedisConnectionFactory redisConn) {
        this(redisConn, ENV_DEFAULT);
    }

    public RedisLockProvider(@NotNull RedisConnectionFactory redisConn, @NotNull String environment) {
        this(redisConn, environment, KEY_PREFIX_DEFAULT);
    }

    public RedisLockProvider(@NotNull RedisConnectionFactory redisConn, @NotNull String environment, @NotNull String keyPrefix) {
        this.redisTemplate = new ShedlockRedisTemplate(redisConn);
        this.environment = environment;
        this.keyPrefix = keyPrefix;
    }

    @NotNull
    public Optional<SimpleLock> lock(@NotNull LockConfiguration lockConfiguration) {
        Expiration expiration;
        String key = this.buildKey(lockConfiguration.getName());
        if (Boolean.TRUE.equals(this.redisTemplate.tryToSetExpiration(key, expiration = RedisLockProvider.getExpiration(lockConfiguration.getLockAtMostUntil()), RedisStringCommands.SetOption.SET_IF_ABSENT))) {
            return Optional.of(new RedisLock(key, this.redisTemplate, lockConfiguration));
        }
        return Optional.empty();
    }

    private static Expiration getExpiration(Instant until) {
        return Expiration.from((long)RedisLockProvider.getMsUntil(until), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static long getMsUntil(Instant until) {
        return Duration.between(ClockProvider.now(), until).toMillis();
    }

    String buildKey(String lockName) {
        return String.format("%s:%s:%s", this.keyPrefix, this.environment, lockName);
    }

    private static class ShedlockRedisTemplate
    extends StringRedisTemplate {
        private ShedlockRedisTemplate(RedisConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        private Boolean tryToSetExpiration(String key, Expiration expiration, RedisStringCommands.SetOption option) {
            return (Boolean)this.execute(connection -> connection.set(this.serialize(key), this.buildValue(), expiration, option), false);
        }

        private byte[] buildValue() {
            return this.serialize(String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname()));
        }

        private byte[] serialize(String string) {
            return this.getStringSerializer().serialize((Object)string);
        }
    }

    private static final class RedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final ShedlockRedisTemplate redisTemplate;

        private RedisLock(String key, ShedlockRedisTemplate redisTemplate, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.redisTemplate = redisTemplate;
        }

        public void doUnlock() {
            Expiration keepLockFor = RedisLockProvider.getExpiration(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor.getExpirationTimeInMilliseconds() <= 0L) {
                try {
                    this.redisTemplate.delete(this.key);
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                this.redisTemplate.tryToSetExpiration(this.key, keepLockFor, RedisStringCommands.SetOption.SET_IF_PRESENT);
            }
        }
    }
}

