/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.jedis;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.Pool;

public class JedisLockProvider
implements LockProvider {
    private static final String KEY_PREFIX = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final JedisTemplate jedisTemplate;
    private final String environment;

    public JedisLockProvider(@NotNull Pool<Jedis> jedisPool) {
        this(jedisPool, ENV_DEFAULT);
    }

    public JedisLockProvider(@NotNull Pool<Jedis> jedisPool, @NotNull String environment) {
        this.jedisTemplate = new JedisPoolTemplate(jedisPool);
        this.environment = environment;
    }

    public JedisLockProvider(@NotNull JedisCluster jedisCluster, @NotNull String environment) {
        this.jedisTemplate = new JedisClusterTemplate(jedisCluster);
        this.environment = environment;
    }

    @NotNull
    public Optional<SimpleLock> lock(@NotNull LockConfiguration lockConfiguration) {
        long expireTime = JedisLockProvider.getMsUntil(lockConfiguration.getLockAtMostUntil());
        String key = JedisLockProvider.buildKey(lockConfiguration.getName(), this.environment);
        String rez = this.jedisTemplate.set(key, JedisLockProvider.buildValue(), SetParams.setParams().nx().px(expireTime));
        if ("OK".equals(rez)) {
            return Optional.of(new RedisLock(key, this.jedisTemplate, lockConfiguration));
        }
        return Optional.empty();
    }

    private static long getMsUntil(Instant instant) {
        return Duration.between(ClockProvider.now(), instant).toMillis();
    }

    static String buildKey(String lockName, String env) {
        return String.format("%s:%s:%s", KEY_PREFIX, env, lockName);
    }

    private static String buildValue() {
        return String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname());
    }

    private static class JedisClusterTemplate
    implements JedisTemplate {
        private final JedisCluster jedisCluster;

        private JedisClusterTemplate(JedisCluster jedisCluster) {
            this.jedisCluster = jedisCluster;
        }

        @Override
        public String set(String key, String value, SetParams setParams) {
            return this.jedisCluster.set(key, value, setParams);
        }

        @Override
        public void del(String key) {
            this.jedisCluster.del(key);
        }
    }

    private static class JedisPoolTemplate
    implements JedisTemplate {
        private final Pool<Jedis> jedisPool;

        private JedisPoolTemplate(Pool<Jedis> jedisPool) {
            this.jedisPool = jedisPool;
        }

        @Override
        public String set(String key, String value, SetParams setParams) {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                String string = jedis.set(key, value, setParams);
                return string;
            }
        }

        @Override
        public void del(String key) {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.del(key);
            }
        }
    }

    private static interface JedisTemplate {
        public String set(String var1, String var2, SetParams var3);

        public void del(String var1);
    }

    private static final class RedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final JedisTemplate jedisTemplate;

        private RedisLock(String key, JedisTemplate jedisTemplate, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.jedisTemplate = jedisTemplate;
        }

        public void doUnlock() {
            long keepLockFor = JedisLockProvider.getMsUntil(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor <= 0L) {
                try {
                    this.jedisTemplate.del(this.key);
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                this.jedisTemplate.set(this.key, JedisLockProvider.buildValue(), SetParams.setParams().xx().px(keepLockFor));
            }
        }
    }
}

