/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import imagej.patcher.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class TestUtils {
    public static File createTemporaryDirectory(String prefix) throws IOException {
        return TestUtils.createTemporaryDirectory(prefix, TestUtils.getCallingClass(null));
    }

    public static File createTemporaryDirectory(String prefix, Class<?> forClass) throws IOException {
        File baseDirectory;
        File file;
        String path;
        URL directory = Utils.getLocation(forClass);
        if (directory != null && "file".equals(directory.getProtocol()) && (path = directory.getPath()) != null && path.endsWith("/target/test-classes/") && (file = File.createTempFile(prefix, "", baseDirectory = new File(path.substring(0, path.length() - 13)))).delete() && file.mkdir()) {
            return file;
        }
        return TestUtils.createTemporaryDirectory(prefix, "", null);
    }

    public static Class<?> getCallingClass(Class<?> excluding) {
        String thisClassName = TestUtils.class.getName();
        String thisClassName2 = excluding == null ? null : excluding.getName();
        Thread currentThread = Thread.currentThread();
        for (StackTraceElement element : currentThread.getStackTrace()) {
            String thatClassName = element.getClassName();
            if (thatClassName == null || thatClassName.equals(thisClassName) || thatClassName.equals(thisClassName2) || thatClassName.startsWith("java.lang.")) continue;
            ClassLoader loader = currentThread.getContextClassLoader();
            try {
                return loader.loadClass(element.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Could not load " + element.getClassName() + " with the current context class loader (" + loader + ")!");
            }
        }
        throw new UnsupportedOperationException("No calling class outside " + thisClassName + " found!");
    }

    public static File createTemporaryDirectory(String prefix, String suffix, File directory) throws IOException {
        for (int counter = 0; counter < 10; ++counter) {
            File file = File.createTempFile(prefix, suffix, directory);
            if (!file.delete()) {
                throw new IOException("Could not delete file " + file);
            }
            if (!file.mkdir()) continue;
            return file;
        }
        throw new IOException("Could not create temporary directory (too many race conditions?)");
    }

    public static boolean deleteRecursively(File directory) {
        if (directory == null) {
            return true;
        }
        File[] list = directory.listFiles();
        if (list == null) {
            return true;
        }
        for (File file : list) {
            if (!(file.isFile() ? !file.delete() : file.isDirectory() && !TestUtils.deleteRecursively(file))) continue;
            return false;
        }
        return directory.delete();
    }

    public static void makeJar(File jarFile, String ... classNames) throws IOException {
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));
        byte[] buffer = new byte[16384];
        StringBuilder pluginsConfig = new StringBuilder();
        for (String className : classNames) {
            int count;
            String path = className.replace('.', '/') + ".class";
            InputStream in = TestUtils.class.getResourceAsStream("/" + path);
            ZipEntry entry = new ZipEntry(path);
            jar.putNextEntry(entry);
            while ((count = in.read(buffer)) >= 0) {
                jar.write(buffer, 0, count);
            }
            if (className.indexOf(95) >= 0) {
                String name = className.substring(className.lastIndexOf(46) + 1).replace('_', ' ');
                pluginsConfig.append("Plugins, \"").append(name).append("\", ").append(className).append("\n");
            }
            in.close();
        }
        if (pluginsConfig.length() > 0) {
            ZipEntry entry = new ZipEntry("plugins.config");
            jar.putNextEntry(entry);
            jar.write(pluginsConfig.toString().getBytes());
        }
        jar.close();
    }
}

