/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import imagej.patcher.Headless_Example_Plugin;
import imagej.patcher.LegacyClassLoader;
import imagej.patcher.LegacyEnvironment;
import imagej.patcher.LegacyInjector;
import imagej.patcher.Utils;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class LegacyHeadlessTest {
    private String threadName;

    @Before
    public void saveThreadName() {
        this.threadName = Thread.currentThread().getName();
    }

    @After
    public void restoreThreadName() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
    }

    @Test
    public void testHeadless() throws Exception {
        Assert.assertTrue((boolean)LegacyHeadlessTest.runExampleDialogPlugin(true));
    }

    @Test
    public void testPatchIsRequired() throws Exception {
        Assume.assumeTrue((boolean)GraphicsEnvironment.isHeadless());
        Assert.assertFalse((boolean)LegacyHeadlessTest.runExampleDialogPlugin(false));
    }

    @Test
    public void saveDialog() throws Exception {
        Assert.assertTrue((boolean)LegacyHeadlessTest.runExamplePlugin(true, "SaveDialog", "file=README.txt", "true"));
    }

    @Test
    public void booleanTest() throws Exception {
        LegacyHeadlessTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key", "This is the key! true");
        LegacyHeadlessTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key ", "This is the key! true");
        LegacyHeadlessTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key=1", "This is the key! false");
        LegacyHeadlessTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key1", "This is the key! false");
        LegacyHeadlessTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the next key!]", "This is the next key! false");
    }

    private static boolean runExampleDialogPlugin(boolean patchHeadless) throws Exception {
        return LegacyHeadlessTest.runExamplePlugin(patchHeadless, "the argument", "prefix=[*** ]", "*** the argument");
    }

    private static boolean runExamplePlugin(boolean patchHeadless, String arg, String macroOptions, String expectedValue) throws Exception {
        LegacyClassLoader loader = new LegacyClassLoader(patchHeadless){
            {
                this.addURL(Utils.getLocation(Headless_Example_Plugin.class));
            }
        };
        LegacyEnvironment ij1 = new LegacyEnvironment((ClassLoader)loader, patchHeadless);
        try {
            ij1.setMacroOptions(macroOptions);
            String value = ij1.runPlugIn(Headless_Example_Plugin.class.getName(), arg).toString();
            Assert.assertEquals((Object)expectedValue, (Object)value);
            return true;
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof InvocationTargetException) || t.getCause() == null || !(t.getCause() instanceof HeadlessException)) {
                t.printStackTrace();
            }
            return false;
        }
    }

    static {
        LegacyInjector.preinit();
    }
}

