/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import ij.Macro;
import imagej.patcher.LegacyEnvironment;
import imagej.patcher.LegacyInjector;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class HeadlessEnvironmentTest {
    @Test
    public void testMacro() throws Exception {
        LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
        String propertyName = "headless.test.property" + Math.random();
        String propertyValue = "Hello, world!";
        System.setProperty(propertyName, "(unset)");
        Assert.assertFalse((boolean)"Hello, world!".equals(System.getProperty(propertyName)));
        ij1.runMacro("call(\"java.lang.System.setProperty\", \"" + propertyName + "\", getArgument());", "Hello, world!");
        Assert.assertEquals((Object)"Hello, world!", (Object)System.getProperty(propertyName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncapsulation() throws Exception {
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        try {
            Macro.setOptions((String)"(unset)");
            Assert.assertEquals((Object)"(unset) ", (Object)Macro.getOptions());
            LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
            ij1.runMacro("call(\"ij.Macro.setOptions\", \"Hello, world!\");", null);
            Assert.assertEquals((Object)"(unset) ", (Object)Macro.getOptions());
            Method getOptions = ij1.getClassLoader().loadClass("ij.Macro").getMethod("getOptions", new Class[0]);
            Assert.assertEquals((Object)"Hello, world! ", (Object)getOptions.invoke(null, new Object[0]));
        }
        finally {
            thread.setName(savedName);
        }
    }

    static {
        LegacyInjector.preinit();
    }
}

