/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import imagej.patcher.HeadlessGenericDialog;
import imagej.patcher.LegacyInjector;
import java.util.HashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.junit.Assert;
import org.junit.Test;

public class HeadlessCompletenessTest {
    @Test
    public void missingGenericDialogMethods() throws Exception {
        String name;
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        String originalName = "ij.gui.GenericDialog";
        CtClass original = pool.get("ij.gui.GenericDialog");
        String headlessName = HeadlessGenericDialog.class.getName();
        CtClass headless = pool.get(headlessName);
        HashMap<String, CtMethod> methods = new HashMap<String, CtMethod>();
        for (CtMethod ctMethod : headless.getMethods()) {
            if (headless != ctMethod.getDeclaringClass()) continue;
            name = ctMethod.getLongName();
            Assert.assertTrue((boolean)name.startsWith(headlessName + "."));
            name = name.substring(headlessName.length() + 1);
            methods.put(name, ctMethod);
        }
        for (String string : new String[]{"actionPerformed(java.awt.event.ActionEvent)", "adjustmentValueChanged(java.awt.event.AdjustmentEvent)", "getInsets(int,int,int,int)", "getValue(java.lang.String)", "isMatch(java.lang.String,java.lang.String)", "itemStateChanged(java.awt.event.ItemEvent)", "keyPressed(java.awt.event.KeyEvent)", "keyReleased(java.awt.event.KeyEvent)", "keyTyped(java.awt.event.KeyEvent)", "paint(java.awt.Graphics)", "parseDouble(java.lang.String)", "setCancelLabel(java.lang.String)", "textValueChanged(java.awt.event.TextEvent)", "windowActivated(java.awt.event.WindowEvent)", "windowClosed(java.awt.event.WindowEvent)", "windowClosing(java.awt.event.WindowEvent)", "windowDeactivated(java.awt.event.WindowEvent)", "windowDeiconified(java.awt.event.WindowEvent)", "windowIconified(java.awt.event.WindowEvent)", "windowOpened(java.awt.event.WindowEvent)"}) {
            methods.put(string, null);
        }
        for (CtMethod ctMethod : original.getMethods()) {
            if (original != ctMethod.getDeclaringClass()) continue;
            name = ctMethod.getLongName();
            Assert.assertTrue((boolean)name.startsWith("ij.gui.GenericDialog."));
            name = name.substring("ij.gui.GenericDialog".length() + 1);
            Assert.assertTrue((String)(name + " is not overridden"), (boolean)methods.containsKey(name));
        }
    }

    static {
        LegacyInjector.preinit();
    }
}

