/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import imagej.patcher.CodeHacker;
import imagej.patcher.LegacyEnvironment;
import imagej.patcher.TestUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.ClassPool;
import org.junit.Assert;
import org.junit.Test;

public class FatJarTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFatJars() throws Exception {
        File tmp = TestUtils.createTemporaryDirectory("fat-jars-");
        File plugins = new File(tmp, "plugins");
        Assert.assertTrue((plugins.exists() || plugins.mkdir() ? 1 : 0) != 0);
        File jars = new File(tmp, "jars");
        if (jars.exists()) {
            TestUtils.deleteRecursively(jars);
        }
        Assert.assertTrue((boolean)jars.mkdir());
        CodeHacker hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
        hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"1\";");
        hacker.writeJar(new File(jars, "batik.jar"));
        hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
        hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"2\";");
        hacker.writeJar(new File(jars, "xalan.jar"));
        String expect = "2";
        if (!jars.list()[0].equals("batik.jar")) {
            System.err.println("first entry is " + jars.list()[0]);
            Assert.assertTrue((boolean)new File(jars, "batik.jar").renameTo(new File(jars, "xalax.jar")));
            Assert.assertTrue((boolean)new File(jars, "xalan.jar").renameTo(new File(jars, "batik.jar")));
            System.err.println("Now, first entry is " + jars.list()[0]);
            Assert.assertTrue((boolean)jars.list()[0].equals("batik.jar"));
            expect = "1";
        }
        String savedPluginsDir = System.getProperty("plugins.dir");
        try {
            System.setProperty("plugins.dir", tmp.getAbsolutePath());
            LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
            Assert.assertEquals((Object)expect, (Object)ij1.runPlugIn(this.getClass().getName(), "").toString());
        }
        finally {
            if (savedPluginsDir == null) {
                System.clearProperty("plugins.dir");
            } else {
                System.setProperty("plugins.dir", savedPluginsDir);
            }
        }
    }
}

