/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.IJ;
import ij.ImageJ;
import java.awt.GraphicsEnvironment;
import net.imagej.patcher.LegacyHooks;
import net.imagej.patcher.LegacyInjector;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class LegacyHooksTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdownHooks() throws Exception {
        Assume.assumeTrue((!GraphicsEnvironment.isHeadless() ? 1 : 0) != 0);
        final Boolean[] results = new Boolean[3];
        final Thread[] quitThread = new Thread[1];
        LegacyInjector.installHooks((ClassLoader)Thread.currentThread().getContextClassLoader(), (LegacyHooks)new LegacyHooks(){

            public boolean quit() {
                results[0] = results[0] == null;
                return super.quit();
            }

            public boolean interceptCloseAllWindows() {
                results[1] = results[1] == null;
                return super.interceptCloseAllWindows();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean disposing() {
                results[2] = results[2] == null;
                Thread[] threadArray = quitThread;
                synchronized (quitThread) {
                    quitThread[0] = Thread.currentThread();
                    quitThread.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return super.disposing();
                }
            }
        });
        ImageJ ij = new ImageJ(2);
        ij.exitWhenQuitting(false);
        ij.quit();
        long timeout = 10L;
        Thread[] threadArray = quitThread;
        synchronized (quitThread) {
            if (quitThread[0] == null) {
                quitThread.wait(10000L);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            Assert.assertNotNull((String)"ImageJ1 Quit thread is not set", (Object)quitThread[0]);
            if (quitThread[0] == Thread.currentThread()) {
                Assert.fail((String)"ImageJ1 is not quitting on a new thread");
            }
            quitThread[0].join(10000L);
            if (quitThread[0].isAlive()) {
                Assert.fail((String)"ImageJ1 failed to quit after 10 seconds");
            }
            Assert.assertNull((Object)IJ.getInstance());
            this.assertValid("quit", results[0]);
            this.assertValid("interceptCloseAllWindows", results[1]);
            this.assertValid("disposing", results[2]);
            return;
        }
    }

    private void assertValid(String method, Boolean value) {
        Assert.assertNotNull((String)("LegacyHooks#" + method + "() not called"), (Object)value);
        Assert.assertTrue((String)("LegacyHooks#" + method + "() called more than once"), (boolean)value);
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

