/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.IJ;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class JavaAgentIT {
    private StackTraceElement[] trace;

    @Test
    public void testAgentInit() throws Exception {
        Assume.assumeTrue((boolean)"init".equals(System.getProperty("legacy.agent.mode")));
        IJ.log((String)"Now ij.IJ is loaded.");
        Assert.assertNotNull((Object)IJ.class.getField("_hooks"));
    }

    @Test
    public void testAgentDebug() {
        Assume.assumeTrue((boolean)"debug".equals(System.getProperty("legacy.agent.mode")));
        try {
            this.trace = Thread.currentThread().getStackTrace();
            IJ.log((String)"Now ij.IJ would be loaded.");
            Assert.assertTrue((String)"This code should not be reached", (boolean)false);
        }
        catch (ExceptionInInitializerError e) {
            Throwable e2 = e.getCause();
            Assert.assertTrue((e2 != null ? 1 : 0) != 0);
            String message = e2.getMessage();
            Assert.assertTrue((String)("Message should begin with 'Loading ij/IJ': " + message), (boolean)message.startsWith("Loading ij/IJ "));
            StackTraceElement[] stackTrace = e2.getStackTrace();
            Assert.assertEquals((Object)this.getFileName(stackTrace, 0), (Object)this.getFileName(this.trace, 1));
            Assert.assertEquals((long)this.getLineNumber(stackTrace, 0), (long)(this.getLineNumber(this.trace, 1) + 1));
            System.err.println("All is fine, we got the exception:");
            e2.printStackTrace();
        }
    }

    private int getLineNumber(StackTraceElement[] trace, int no) {
        if (trace == null || trace.length <= no) {
            return -1;
        }
        return trace[no].getLineNumber();
    }

    private String getFileName(StackTraceElement[] trace, int no) {
        if (trace == null || trace.length <= no) {
            return null;
        }
        return trace[no].getFileName();
    }
}

