/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.ClassPool;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.util.FileUtils;

public class FatJarTest {
    private String threadName;
    private ClassLoader threadLoader;

    @After
    public void after() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        if (this.threadLoader != null) {
            Thread.currentThread().setContextClassLoader(this.threadLoader);
        }
    }

    @Before
    public void before() throws IOException {
        this.threadName = Thread.currentThread().getName();
        this.threadLoader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFatJars() throws Exception {
        File tmp = org.scijava.test.TestUtils.createTemporaryDirectory((String)"fat-jars-");
        File plugins = new File(tmp, "plugins");
        Assert.assertTrue((plugins.exists() || plugins.mkdir() ? 1 : 0) != 0);
        File jars = new File(tmp, "jars");
        if (jars.exists()) {
            FileUtils.deleteRecursively((File)jars);
        }
        Assert.assertTrue((boolean)jars.mkdir());
        CodeHacker hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
        hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"1\";");
        hacker.writeJar(new File(jars, "batik.jar"));
        hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
        hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"2\";");
        hacker.writeJar(new File(jars, "xalan.jar"));
        String expect = "2";
        if (!jars.list()[0].equals("batik.jar")) {
            System.err.println("first entry is " + jars.list()[0]);
            Assert.assertTrue((boolean)new File(jars, "batik.jar").renameTo(new File(jars, "xalax.jar")));
            Assert.assertTrue((boolean)new File(jars, "xalan.jar").renameTo(new File(jars, "batik.jar")));
            System.err.println("Now, first entry is " + jars.list()[0]);
            if (!jars.list()[0].equals("batik.jar")) {
                Assert.assertTrue((boolean)new File(jars, "xalax.jar").renameTo(new File(jars, "xalaa.jar")));
            }
            Assert.assertTrue((boolean)jars.list()[0].equals("batik.jar"));
            expect = "1";
        }
        String savedPluginsDir = System.getProperty("plugins.dir");
        try {
            System.setProperty("plugins.dir", tmp.getAbsolutePath());
            LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
            Assert.assertEquals((Object)expect, (Object)ij1.runPlugIn(this.getClass().getName(), "").toString());
        }
        finally {
            if (savedPluginsDir == null) {
                System.clearProperty("plugins.dir");
            } else {
                System.setProperty("plugins.dir", savedPluginsDir);
            }
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

