/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.ImageJ;
import java.applet.Applet;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.imagej.patcher.Headless_Example_Plugin;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Set_Property;
import net.imagej.patcher.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.scijava.util.FileUtils;

public class ExtraPluginDirsTest {
    private File tmpDir;
    private String threadName;
    private ClassLoader threadLoader;

    @After
    public void after() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        if (this.threadLoader != null) {
            Thread.currentThread().setContextClassLoader(this.threadLoader);
        }
    }

    @Before
    public void before() throws IOException {
        this.threadName = Thread.currentThread().getName();
        this.threadLoader = Thread.currentThread().getContextClassLoader();
        this.tmpDir = org.scijava.test.TestUtils.createTemporaryDirectory((String)"legacy-");
    }

    @Test
    public void findsExtraPluginDir() throws Exception {
        File jarFile = new File(this.tmpDir, "Set_Property.jar");
        TestUtils.makeJar(jarFile, Set_Property.class.getName());
        Assert.assertTrue((String)(jarFile.getAbsolutePath() + " exists"), (boolean)jarFile.exists());
        System.setProperty("ij1.plugin.dirs", this.tmpDir.getAbsolutePath());
        String key = "random-" + Math.random();
        System.setProperty(key, "321");
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(true, true);
        ij1.run("Set Property", "key=" + key + " value=123");
        Assert.assertEquals((Object)"123", (Object)System.getProperty(key));
    }

    @Test
    public void knowsAboutJarsDirectory() throws Exception {
        File pluginsDir = new File(this.tmpDir, "plugins");
        Assert.assertTrue((boolean)pluginsDir.mkdirs());
        File jarsDir = new File(this.tmpDir, "jars");
        Assert.assertTrue((boolean)jarsDir.mkdirs());
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
        String helperClassName = TestUtils.class.getName();
        try {
            Assert.assertNull((Object)ij1.runPlugIn(helperClassName, null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File jarFile = new File(jarsDir, "helper.jar");
        TestUtils.makeJar(jarFile, helperClassName);
        System.setProperty("plugins.dir", pluginsDir.getAbsolutePath());
        ij1 = TestUtils.getTestEnvironment();
        try {
            Assert.assertNotNull((Object)ij1.runPlugIn(helperClassName, null));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.assertNull((Object)("Should have found " + helperClassName + " in " + jarFile));
        }
    }

    @Test
    public void extraDirectory() throws Exception {
        int count;
        for (File file : this.tmpDir.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.deleteRecursively((File)file);
                continue;
            }
            file.delete();
        }
        String path = Headless_Example_Plugin.class.getName().replace('.', '/') + ".class";
        File output = new File(this.tmpDir, path);
        Assert.assertTrue((boolean)output.getParentFile().mkdirs());
        FileOutputStream out = new FileOutputStream(output);
        InputStream in = this.getClass().getResource("/" + path).openStream();
        byte[] buffer = new byte[65536];
        while ((count = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, count);
        }
        in.close();
        ((OutputStream)out).close();
        PrintStream print = new PrintStream(new File(this.tmpDir, "plugins.config"));
        String menuLabel = "Set Classfile URL property";
        print.println("Plugins, \"Set Classfile URL property\", " + Headless_Example_Plugin.class.getName() + "(\"ClassfileURL\")");
        print.close();
        String property = "ij.patcher.test." + Math.random();
        System.clearProperty(property);
        Assert.assertNull((Object)System.getProperty(property));
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
        ij1.addPluginClasspath(new File[]{this.tmpDir});
        ij1.run("Set Classfile URL property", "property=" + property);
        Assert.assertEquals((Object)(this.tmpDir.toURI().toURL().toString() + path), (Object)System.getProperty(property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void correctSubmenu() throws Exception {
        Assume.assumeTrue((!GraphicsEnvironment.isHeadless() ? 1 : 0) != 0);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            File jarFile = new File(this.tmpDir, "Submenu_Test.jar");
            TestUtils.makeJar(jarFile, "Submenu_Test");
            Assert.assertTrue((String)(jarFile.getAbsolutePath() + " exists"), (boolean)jarFile.exists());
            System.setProperty("ij1.plugin.dirs", this.tmpDir.getAbsolutePath());
            LegacyEnvironment ij1 = TestUtils.getTestEnvironment(false, true);
            Class<?> imagej = ij1.getClassLoader().loadClass(ImageJ.class.getName());
            imagej.getConstructor(Applet.class, Integer.TYPE).newInstance(null, 2);
            ij1.run("Submenu Test", "menupath=[Plugins>Submenu Test] class=Submenu_Test");
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

