/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.utils;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.hasor.utils.NameThreadFactory;

public class TimerManager {
    private final int defaultTimeout;
    private final Timer timer;

    public TimerManager(int defaultTimeout, ClassLoader loader) {
        this(defaultTimeout, "RSF", loader);
    }

    public TimerManager(int defaultTimeout, String name, ClassLoader loader) {
        this.defaultTimeout = defaultTimeout;
        name = Objects.requireNonNull(name);
        this.timer = new HashedWheelTimer((ThreadFactory)new NameThreadFactory(name + "-Timer-%s", loader));
    }

    public void atTime(TimerTask timeTask) {
        this.atTime(timeTask, this.defaultTimeout);
    }

    public void atTime(TimerTask timeTask, int timeout) {
        int reqTimeout = this.validateTimeout(timeout);
        this.timer.newTimeout(timeTask, (long)reqTimeout, TimeUnit.MILLISECONDS);
    }

    private int validateTimeout(int timeout) {
        if (timeout <= 0) {
            timeout = this.defaultTimeout;
        }
        return timeout;
    }
}

