/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.utils;

class LRU<K, V> {
    private LRU_Entity root = null;
    private int linkSize = 0;
    private int maxSize = 400;

    LRU() {
    }

    private LRU_Entity entByKey(K key) {
        LRU_Entity searchRoot;
        if (this.root == null) {
            return null;
        }
        LRU_Entity currentRoot = searchRoot = this.root;
        do {
            if (!key.equals(currentRoot.key)) continue;
            return currentRoot;
        } while ((currentRoot = currentRoot.next) != searchRoot);
        return null;
    }

    public V get(K key) {
        LRU_Entity valEnt = this.entByKey(key);
        if (valEnt != null) {
            ++valEnt.count;
            return valEnt.val;
        }
        return null;
    }

    public V put(K key, V val) {
        LRU_Entity valEnt = this.entByKey(key);
        if (valEnt != null) {
            if (valEnt.key.equals(key)) {
                ++valEnt.count;
                return valEnt.val;
            }
            valEnt.count = 0;
            Object oldVal = valEnt.val;
            valEnt.val = val;
            this.moveOrAdd(valEnt);
            return oldVal;
        }
        valEnt = new LRU_Entity();
        valEnt.count = 0;
        valEnt.isNew = true;
        valEnt.key = key;
        valEnt.val = val;
        this.moveOrAdd(valEnt);
        return null;
    }

    private void moveOrAdd(LRU_Entity valEnt) {
        this.weedOut();
        int realSize = this.linkSize;
        if (!valEnt.isNew) {
            valEnt.pre.next = valEnt.next;
            valEnt.next.pre = valEnt.pre;
            --realSize;
        }
        if (this.root == null) {
            this.root = valEnt;
        }
        LRU_Entity root = this.root;
        valEnt.pre = root.pre;
        root.pre = valEnt;
        root.next = valEnt;
        valEnt.next = root;
        this.root = valEnt;
        this.linkSize = ++realSize;
    }

    private void weedOut() {
        if (this.linkSize > this.maxSize) {
            System.out.println("weedOut");
        }
    }

    private class LRU_Entity {
        public LRU_Entity pre;
        public LRU_Entity next;
        public int count;
        public boolean isNew;
        public K key;
        public V val;

        private LRU_Entity() {
        }
    }
}

