/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.utils;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.hasor.utils.NameThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutesManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Supplier<ThreadPoolExecutor> defaultExecutorProvider;
    private ThreadPoolExecutor defaultExecutor;
    private final ConcurrentMap<String, ThreadPoolExecutor> servicePoolCache;

    public ExecutesManager(int minCorePoolSize, int maxCorePoolSize, int queueSize, long keepAliveTime, ClassLoader loader) {
        this.logger.info("executesManager init ->> minCorePoolSize ={}, maxCorePoolSize ={}, queueSize ={}, keepAliveTime ={}", new Object[]{minCorePoolSize, maxCorePoolSize, queueSize, keepAliveTime});
        LinkedBlockingQueue inWorkQueue = new LinkedBlockingQueue(queueSize);
        this.defaultExecutorProvider = () -> new ThreadPoolExecutor(minCorePoolSize, maxCorePoolSize, keepAliveTime, TimeUnit.SECONDS, inWorkQueue, (ThreadFactory)new NameThreadFactory("RSF-Biz-%s", loader), new ThreadPoolExecutor.AbortPolicy());
        this.defaultExecutor = this.defaultExecutorProvider.get();
        this.servicePoolCache = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    }

    public Executor getExecute(String serviceUniqueName) {
        ThreadPoolExecutor executor;
        if (!this.servicePoolCache.isEmpty() && serviceUniqueName != null && (executor = (ThreadPoolExecutor)this.servicePoolCache.get(serviceUniqueName)) != null) {
            return executor;
        }
        return this.defaultExecutor;
    }

    public void shutdown() {
        ArrayList executorList = new ArrayList(this.servicePoolCache.values());
        executorList.add(this.defaultExecutor);
        this.servicePoolCache.clear();
        this.defaultExecutor = this.defaultExecutorProvider.get();
        for (ThreadPoolExecutor exec : executorList) {
            if (exec == null) continue;
            exec.shutdown();
        }
        while (true) {
            boolean jump = true;
            for (ThreadPoolExecutor exec : executorList) {
                if (exec == null || exec.isShutdown()) continue;
                jump = false;
                break;
            }
            if (jump) break;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }
}

