/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.tconsole;

import java.io.StringWriter;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.tconsole.TelCommand;
import net.hasor.tconsole.TelExecutor;
import net.hasor.utils.StringUtils;

@Singleton
public class ListRsfInstruct
implements TelExecutor {
    @Inject
    private RsfContext rsfContext;

    public String helpInfo() {
        return "show service list.\r\n - list      (show all service id list.)\r\n - list -h   (show help info.)\r\n";
    }

    public String doCommand(TelCommand telCommand) throws Throwable {
        StringWriter sw = new StringWriter();
        String[] args = telCommand.getCommandArgs();
        if (args != null && args.length > 0 && "-h".equalsIgnoreCase(args[0])) {
            sw.write(this.helpInfo());
            return sw.toString();
        }
        sw.write(">>>>>>>>>>>>>>>>>>>>>>>>  list  <<<<<<<<<<<<<<<<<<<<<<<<\r\n");
        List<String> serviceList = this.rsfContext.getServiceIDs();
        int maxLength = 0;
        for (String serviceID : serviceList) {
            maxLength = maxLength < serviceID.length() ? serviceID.length() : maxLength;
        }
        for (String serviceID : serviceList) {
            RsfBindInfo info = this.rsfContext.getServiceInfo(serviceID);
            boolean isProvider = this.rsfContext.getServiceProvider(info) != null;
            String itemStr = StringUtils.rightPad((String)serviceID, (int)maxLength, (String)" ") + "  -> " + (isProvider ? "Provider" : "Consumer");
            sw.write(">> " + itemStr + "\r\n");
        }
        return sw.toString();
    }
}

