/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.tconsole;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.hasor.rsf.RsfContext;
import net.hasor.tconsole.TelCommand;
import net.hasor.tconsole.TelExecutor;
import net.hasor.tconsole.TelReader;
import net.hasor.utils.StringUtils;

@Singleton
public class FlowRsfInstruct
implements TelExecutor {
    @Inject
    private RsfContext rsfContext;

    public String helpInfo() {
        return "service flowControl show/update.\r\n - flow             (show help info.)\r\n - rule -s XXXX     (show service flowControl info of XXXX.)\r\n - flow -u XXXX     (update service flowControl info of XXXX.)\r\n - flow -c XXXX     (clean service flowControl info of XXXX.)";
    }

    public boolean readCommand(TelCommand telCommand, TelReader telReader) {
        String[] args = telCommand.getCommandArgs();
        if (args != null && args.length > 0 && args[0].startsWith("-u")) {
            return telReader.expectDoubleBlankLines();
        }
        return true;
    }

    public String doCommand(TelCommand telCommand) throws Throwable {
        StringWriter sw = new StringWriter();
        String[] args = telCommand.getCommandArgs();
        if (args != null && args.length > 1) {
            String scriptBody;
            String mode = args[0];
            String nameArg = args[1];
            if (mode != null && mode.startsWith("-u") && StringUtils.isBlank((String)(scriptBody = telCommand.getCommandBody()))) {
                return "[ERROR] updated content is empty, ignore.";
            }
            if ("-s".equalsIgnoreCase(mode)) {
                this.showFlowControl(sw, nameArg, this.rsfContext);
            } else if ("-u".equalsIgnoreCase(mode)) {
                this.updateFlowControl(sw, nameArg, telCommand, this.rsfContext);
            } else if ("-c".equalsIgnoreCase(mode)) {
                this.cleanFlowControl(sw, nameArg, telCommand, this.rsfContext);
            } else {
                sw.write("[ERROR] bad args.");
            }
        } else {
            sw.write(">>>>>>>>>>>>>>>>>>>>>>>>  flow  <<<<<<<<<<<<<<<<<<<<<<<<\r\n");
            sw.write(this.helpInfo());
        }
        return sw.toString();
    }

    private void showFlowControl(StringWriter sw, String nameArg, RsfContext rsfContext) throws IOException {
        String body = rsfContext.getUpdater().flowControl(nameArg);
        if (StringUtils.isBlank((String)body)) {
            sw.write("[SUCCEED] content is empty.");
        } else {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(body));
            while ((line = reader.readLine()) != null) {
                sw.write(line + "\r\n");
            }
        }
    }

    private void updateFlowControl(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        String scriptBody = telCommand.getCommandBody();
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
        } else {
            boolean result = rsfContext.getUpdater().updateFlowControl(nameArg, scriptBody);
            sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] update FlowControl of serviceID = " + nameArg);
        }
    }

    private void cleanFlowControl(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
        } else {
            boolean result = rsfContext.getUpdater().updateFlowControl(nameArg, null);
            sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] clean FlowControl of serviceID = " + nameArg);
        }
    }
}

