/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.tconsole;

import java.io.StringWriter;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.hasor.core.AppContext;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfUpdater;
import net.hasor.tconsole.TelCommand;
import net.hasor.tconsole.TelExecutor;

@Singleton
public class DetailRsfInstruct
implements TelExecutor {
    @Inject
    private AppContext appContext;

    public String helpInfo() {
        return "show service info.\r\n - detail         (show help info.)\r\n - detail -h      (show help info.)\r\n - detail xxxx    (show service info of XXXX.)\r\n - detail -a xxxx (show service info of XXXX. if service is Consumer then show Providers)";
    }

    public String doCommand(TelCommand telCommand) throws Throwable {
        RsfBindInfo info;
        boolean isProvider;
        StringWriter sw = new StringWriter();
        String[] args = telCommand.getCommandArgs();
        if (args == null || args.length == 0 || "-h".equalsIgnoreCase(args[0])) {
            sw.write(">>>>>>>>>>>>>>>>>>>>>>>>  " + telCommand.getCommandName() + "  <<<<<<<<<<<<<<<<<<<<<<<<\r\n");
            sw.write(this.helpInfo());
            return sw.toString();
        }
        String serviceID = args[args.length - 1].trim();
        RsfContext rsfContext = (RsfContext)this.appContext.getInstance(RsfContext.class);
        boolean bl = isProvider = rsfContext.getServiceProvider(info = rsfContext.getServiceInfo(serviceID)) != null;
        if (info == null) {
            return "[ERROR] the service '" + serviceID + "' is Undefined.";
        }
        sw.write(">>\r\n");
        sw.write(">>----- Service Info ------\r\n");
        sw.write(">>         ID : " + info.getBindID() + "\r\n");
        sw.write(">>      Group : " + info.getBindGroup() + "\r\n");
        sw.write(">>       Name : " + info.getBindName() + "\r\n");
        sw.write(">>    Version : " + info.getBindVersion() + "\r\n");
        sw.write(">>    Timeout : " + info.getClientTimeout() + "\r\n");
        sw.write(">>  Serialize : " + info.getSerializeType() + "\r\n");
        sw.write(">>   javaType : " + info.getBindType().getName() + "\r\n");
        sw.write(">>    Message : " + info.isMessage() + "\r\n");
        sw.write(">>     Shadow : " + info.isShadow() + "\r\n");
        sw.write(">> SinglePool : " + info.isSharedThreadPool() + "\r\n");
        sw.write(">>       Type : " + (isProvider ? "Provider" : "Consumer") + "\r\n");
        if (!isProvider && args.length == 2 && "-a".equalsIgnoreCase(args[0])) {
            RsfUpdater updater = rsfContext.getUpdater();
            List<InterAddress> allList = updater.queryAllAddresses(serviceID);
            List<InterAddress> availableList = updater.queryAvailableAddresses(serviceID);
            List<InterAddress> unitList = updater.queryLocalUnitAddresses(serviceID);
            sw.write(">>\r\n");
            sw.write(">>---- Subscribe Info -----\r\n");
            sw.write(">>       unit : " + DetailRsfInstruct.evalAddress(unitList) + "\r\n");
            sw.write(">>  available : " + DetailRsfInstruct.evalAddress(availableList) + "\r\n");
            sw.write(">>        all : " + DetailRsfInstruct.evalAddress(allList) + "\r\n");
        }
        return sw.toString();
    }

    private static String evalAddress(List<InterAddress> addressSet) {
        StringBuilder addrList = new StringBuilder("");
        for (InterAddress inter : addressSet) {
            if (inter == null) continue;
            if (addrList.length() > 0) {
                addrList.append(" , ");
            }
            addrList.append(inter.toHostSchema());
        }
        addrList.insert(0, '[');
        addrList.append(']');
        return addrList.toString();
    }
}

