/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.serialize.coder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.hasor.core.Environment;
import net.hasor.rsf.SerializeCoder;
import net.hasor.rsf.hessian.hessian.io.HessianInput;
import net.hasor.rsf.hessian.hessian.io.HessianOutput;
import net.hasor.rsf.hessian.hessian.io.SerializerFactory;

public class HessianSerializeCoder
implements SerializeCoder {
    private SerializerFactory serializerFactory = null;

    @Override
    public void initCoder(Environment environment) {
        this.serializerFactory = new SerializerFactory(environment.getClassLoader());
    }

    @Override
    public byte[] encode(Object object) throws IOException {
        ByteArrayOutputStream binary = new ByteArrayOutputStream();
        HessianOutput hout = new HessianOutput(binary);
        hout.setSerializerFactory(this.serializerFactory);
        hout.writeObject(object);
        return binary.toByteArray();
    }

    @Override
    public Object decode(byte[] bytes, Class<?> returnType) throws IOException {
        if (bytes == null) {
            return null;
        }
        HessianInput input = new HessianInput(new ByteArrayInputStream(bytes));
        input.setSerializerFactory(this.serializerFactory);
        return input.readObject(returnType);
    }
}

