/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.serialize;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.core.Environment;
import net.hasor.core.XmlNode;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.SerializeCoder;
import net.hasor.rsf.domain.RsfException;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeFactory {
    protected static Logger logger = LoggerFactory.getLogger(SerializeFactory.class);
    private Map<String, SerializeCoder> coderMap = new HashMap<String, SerializeCoder>();

    public SerializeCoder getSerializeCoder(String codeName) {
        return this.coderMap.get(codeName);
    }

    public void registerSerializeCoder(String codeName, SerializeCoder decoder) {
        this.coderMap.put(codeName, decoder);
    }

    public static SerializeFactory createFactory(RsfEnvironment environment) {
        SerializeFactory factory = new SerializeFactory();
        XmlNode[] atNode = environment.getSettings().getXmlNodeArray("hasor.rsfConfig.serializeType");
        String types = "";
        for (XmlNode e : atNode) {
            List serList = e.getChildren("serialize");
            for (XmlNode s : serList) {
                SerializeFactory.initSerialize(factory, s, environment);
                types = types + "," + s.getAttribute("name");
            }
        }
        if (!StringUtils.isBlank((String)types)) {
            types = types.substring(1);
        }
        logger.info("SerializeFactory init. -> [{}]", (Object)types);
        return factory;
    }

    private static void initSerialize(SerializeFactory factory, XmlNode atNode, Environment environment) {
        String serializeType = atNode.getAttribute("name");
        String serializeCoder = atNode.getText().trim();
        try {
            Class<?> aClass = environment.getClassLoader().loadClass(serializeCoder);
            SerializeCoder coder = (SerializeCoder)aClass.newInstance();
            coder.initCoder(environment);
            factory.registerSerializeCoder(serializeType, coder);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RsfException(511, (Throwable)e);
        }
    }
}

